/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.reflect.annotation.AnnotationType;

final class AnnotationMetadata<T extends Annotation> {
    private static final boolean hasAnnotationType;
    private static final Map<Class<?>, Object> DEFAULTS;
    private final Class<T> type;
    private final Map<String, Object> properties;
    private volatile transient Method[] memberMethods;

    private static boolean hasAnnotationType(ClassLoader classLoader) {
        try {
            classLoader.loadClass("sun.reflect.annotation.AnnotationType");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    AnnotationMetadata(Class<T> type, Map<String, Object> properties) {
        this.type = type;
        this.properties = properties;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Object get(String property) {
        Object result = this.properties.get(property);
        if (result == null) {
            throw new IncompleteAnnotationException(this.type, property);
        }
        return result.getClass().isArray() && Array.getLength(result) != 0 ? AnnotationMetadata.cloneArray(result) : result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(128);
        result.append('@');
        result.append(this.type.getName());
        result.append('(');
        boolean firstMember = true;
        for (Map.Entry<String, Object> e : this.properties.entrySet()) {
            if (firstMember) {
                firstMember = false;
            } else {
                result.append(", ");
            }
            result.append(e.getKey());
            result.append('=');
            result.append(AnnotationMetadata.memberValueToString(e.getValue()));
        }
        result.append(')');
        return result.toString();
    }

    public int hashCode() {
        int result = 0;
        for (Map.Entry<String, Object> e : this.properties.entrySet()) {
            result += 127 * e.getKey().hashCode() ^ AnnotationMetadata.memberValueHashCode(e.getValue());
        }
        return result;
    }

    private boolean isEqual(Object o) {
        if (!this.type.isInstance(o)) {
            return false;
        }
        if (AnnotationHandler.class.isInstance(o) && ((AnnotationHandler)o).metadata == this) {
            return true;
        }
        for (Method memberMethod : this.getMemberMethods()) {
            Object hisValue;
            String member = memberMethod.getName();
            Object ourValue = this.get(member);
            AnnotationHandler hisHandler = this.asOneOfUs(o);
            if (hisHandler != null) {
                hisValue = hisHandler.metadata.get(member);
            } else {
                try {
                    hisValue = memberMethod.invoke(o, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    return false;
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (AnnotationMetadata.memberValueEquals(ourValue, hisValue)) continue;
            return false;
        }
        return true;
    }

    private AnnotationHandler asOneOfUs(Object o) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(o.getClass()) && (handler = Proxy.getInvocationHandler(o)) instanceof AnnotationHandler) {
            return (AnnotationHandler)handler;
        }
        return null;
    }

    private Method[] getMemberMethods() {
        if (this.memberMethods == null) {
            AccessibleObject[] mm = this.type.getDeclaredMethods();
            AccessibleObject.setAccessible(mm, true);
            this.memberMethods = mm;
        }
        return this.memberMethods;
    }

    public static <T extends Annotation> T buildRandomAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new AnnotationHandler(AnnotationMetadata.randomAnnotation(annotationClass))));
    }

    public static <T extends Annotation> T buildAnnotation(Class<T> annotationClass, Map<String, Object> properties) {
        return (T)((Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new AnnotationHandler(AnnotationMetadata.randomAnnotation(annotationClass, properties))));
    }

    private static boolean memberValueEquals(Object v1, Object v2) {
        Class<?> type = v1.getClass();
        if (!type.isArray()) {
            return v1.equals(v2);
        }
        if (v1 instanceof Object[] && v2 instanceof Object[]) {
            return Arrays.equals((Object[])v1, (Object[])v2);
        }
        if (v2.getClass() != type) {
            return false;
        }
        if (type == byte[].class) {
            return Arrays.equals((byte[])v1, (byte[])v2);
        }
        if (type == char[].class) {
            return Arrays.equals((char[])v1, (char[])v2);
        }
        if (type == double[].class) {
            return Arrays.equals((double[])v1, (double[])v2);
        }
        if (type == float[].class) {
            return Arrays.equals((float[])v1, (float[])v2);
        }
        if (type == int[].class) {
            return Arrays.equals((int[])v1, (int[])v2);
        }
        if (type == long[].class) {
            return Arrays.equals((long[])v1, (long[])v2);
        }
        if (type == short[].class) {
            return Arrays.equals((short[])v1, (short[])v2);
        }
        assert (type == boolean[].class);
        return Arrays.equals((boolean[])v1, (boolean[])v2);
    }

    private static Object cloneArray(Object array) {
        Class<?> type = array.getClass();
        if (type == byte[].class) {
            byte[] byteArray = (byte[])array;
            return byteArray.clone();
        }
        if (type == char[].class) {
            char[] charArray = (char[])array;
            return charArray.clone();
        }
        if (type == double[].class) {
            double[] doubleArray = (double[])array;
            return doubleArray.clone();
        }
        if (type == float[].class) {
            float[] floatArray = (float[])array;
            return floatArray.clone();
        }
        if (type == int[].class) {
            int[] intArray = (int[])array;
            return intArray.clone();
        }
        if (type == long[].class) {
            long[] longArray = (long[])array;
            return longArray.clone();
        }
        if (type == short[].class) {
            short[] shortArray = (short[])array;
            return shortArray.clone();
        }
        if (type == boolean[].class) {
            boolean[] booleanArray = (boolean[])array;
            return booleanArray.clone();
        }
        Object[] objectArray = (Object[])array;
        return objectArray.clone();
    }

    private static int memberValueHashCode(Object value) {
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            return value.hashCode();
        }
        if (type == byte[].class) {
            return Arrays.hashCode((byte[])value);
        }
        if (type == char[].class) {
            return Arrays.hashCode((char[])value);
        }
        if (type == double[].class) {
            return Arrays.hashCode((double[])value);
        }
        if (type == float[].class) {
            return Arrays.hashCode((float[])value);
        }
        if (type == int[].class) {
            return Arrays.hashCode((int[])value);
        }
        if (type == long[].class) {
            return Arrays.hashCode((long[])value);
        }
        if (type == short[].class) {
            return Arrays.hashCode((short[])value);
        }
        if (type == boolean[].class) {
            return Arrays.hashCode((boolean[])value);
        }
        return Arrays.hashCode((Object[])value);
    }

    private static String memberValueToString(Object value) {
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            return value.toString();
        }
        if (type == byte[].class) {
            return Arrays.toString((byte[])value);
        }
        if (type == char[].class) {
            return Arrays.toString((char[])value);
        }
        if (type == double[].class) {
            return Arrays.toString((double[])value);
        }
        if (type == float[].class) {
            return Arrays.toString((float[])value);
        }
        if (type == int[].class) {
            return Arrays.toString((int[])value);
        }
        if (type == long[].class) {
            return Arrays.toString((long[])value);
        }
        if (type == short[].class) {
            return Arrays.toString((short[])value);
        }
        if (type == boolean[].class) {
            return Arrays.toString((boolean[])value);
        }
        return Arrays.toString((Object[])value);
    }

    private static <T extends Annotation> AnnotationMetadata<T> randomAnnotation(Class<T> annotationClass) {
        return AnnotationMetadata.randomAnnotation(annotationClass, new LinkedHashMap<String, Object>());
    }

    private static <T extends Annotation> AnnotationMetadata<T> randomAnnotation(Class<T> annotationClass, Map<String, Object> properties) {
        LinkedHashMap<String, Object> allProps = new LinkedHashMap<String, Object>();
        HashMap defaults = hasAnnotationType ? AnnotationMetadata.getAnnotationDefaults(annotationClass) : new HashMap();
        AccessibleObject[] mm = annotationClass.getDeclaredMethods();
        AccessibleObject.setAccessible(mm, true);
        for (AccessibleObject method : mm) {
            String name = ((Method)method).getName();
            if (properties.containsKey(name)) {
                allProps.put(name, properties.get(name));
                continue;
            }
            Object o = defaults.get(name);
            if (o == null) {
                o = AnnotationMetadata.getTypeDefaults(((Method)method).getReturnType());
            }
            allProps.put(name, o);
        }
        return new AnnotationMetadata<T>(annotationClass, allProps);
    }

    private static Object getTypeDefaults(Class<?> type) {
        Object o = DEFAULTS.get(type);
        if (o != null) {
            return o;
        }
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        if (type == String.class) {
            return "";
        }
        if (type == Class.class) {
            return Void.class;
        }
        try {
            if (type.isEnum()) {
                return Enum.valueOf(type, type.getDeclaredFields()[0].getName());
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unable to randomize annotation: cannot get first enum of " + type);
        }
        throw new UnsupportedOperationException("Type: " + type.getName());
    }

    private static Map<String, Object> getAnnotationDefaults(Class<? extends Annotation> annotationClass) {
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        try {
            Field field = Class.class.getDeclaredField("annotationType");
            field.setAccessible(true);
            AnnotationType type = (AnnotationType)field.get(annotationClass);
            defaults.putAll(type.memberDefaults());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaults;
    }

    static {
        DEFAULTS = new HashMap<Class<?>, Object>(16){
            {
                this.put(Boolean.TYPE, false);
                this.put(Character.TYPE, Character.valueOf('\u0000'));
                this.put(Byte.TYPE, (byte)0);
                this.put(Short.TYPE, (short)0);
                this.put(Integer.TYPE, 0);
                this.put(Long.TYPE, 0L);
                this.put(Float.TYPE, Float.valueOf(0.0f));
                this.put(Double.TYPE, 0.0);
            }
        };
        hasAnnotationType = AnnotationMetadata.hasAnnotationType(AnnotationMetadata.class.getClassLoader());
    }

    private static class AnnotationHandler
    implements InvocationHandler,
    Serializable {
        final AnnotationMetadata metadata;

        public AnnotationHandler(AnnotationMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String member = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (member.equals("equals") && paramTypes.length == 1 && paramTypes[0] == Object.class) {
                return this.metadata.isEqual(args[0]);
            }
            if (member.equals("toString")) {
                return this.metadata.toString();
            }
            if (member.equals("hashCode")) {
                return this.metadata.hashCode();
            }
            if (member.equals("annotationType")) {
                return this.metadata.getType();
            }
            return this.metadata.get(member);
        }
    }
}

