/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal;

import com.mycila.inject.internal.BytecodeGen;
import com.mycila.inject.internal.MethodInvoker;
import com.mycila.inject.internal.WeakCache;
import com.mycila.inject.internal.cglib.core.CodeGenerationException;
import com.mycila.inject.internal.cglib.reflect.FastMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Proxy {
    private static final WeakCache<Method, MethodInvoker> INVOKER_CACHE = new WeakCache<Method, MethodInvoker>(new WeakCache.Provider<Method, MethodInvoker>(){

        @Override
        public MethodInvoker get(final Method method) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers)) {
                try {
                    final FastMethod fastMethod = BytecodeGen.newFastClass(method.getDeclaringClass(), BytecodeGen.Visibility.forMember(method)).getMethod(method);
                    return new MethodInvoker(){

                        @Override
                        public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                            return fastMethod.invoke(target, parameters);
                        }
                    };
                }
                catch (CodeGenerationException codeGenerationException) {
                    // empty catch block
                }
            }
            if (!Modifier.isPublic(modifiers) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method.setAccessible(true);
            }
            return new MethodInvoker(){

                @Override
                public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                    return method.invoke(target, parameters);
                }
            };
        }
    });

    private Proxy() {
    }

    public static MethodInvoker invoker(Method method) {
        return INVOKER_CACHE.get(method);
    }
}

