/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.jsr250;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.mycila.inject.MycilaGuice;
import com.mycila.inject.annotation.Jsr250Singleton;
import com.mycila.inject.internal.guava.base.Supplier;
import com.mycila.inject.internal.guava.collect.Multimap;
import com.mycila.inject.internal.guava.collect.Multimaps;
import com.mycila.inject.internal.guava.collect.SetMultimap;
import com.mycila.inject.jsr250.Jsr250;
import com.mycila.inject.jsr250.Jsr250Destroyer;
import com.mycila.inject.jsr250.Jsr250Injector;
import com.mycila.inject.jsr250.Jsr250InjectorImpl;
import com.mycila.inject.jsr250.Jsr250KeyProvider;
import com.mycila.inject.jsr250.Jsr250PostConstructHandler;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;

final class Jsr250Module
implements Module {
    private final Set<Scope> scopes = new HashSet<Scope>();
    private final Set<Class<? extends Annotation>> scopeAnnotations = new HashSet<Class<? extends Annotation>>();

    Jsr250Module() {
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(Jsr250Injector.class).to(Jsr250InjectorImpl.class).in(Singleton.class);
        binder.bind(Jsr250KeyProvider.class).in(Singleton.class);
        binder.bind(Jsr250PostConstructHandler.class).in(Singleton.class);
        MycilaGuice.in(binder).bindAnnotationInjector(Resource.class, Jsr250KeyProvider.class).handleMethodAfterInjection(PostConstruct.class, Jsr250PostConstructHandler.class).bind(Jsr250Destroyer.class, new Jsr250Destroyer(){
            @Inject
            Injector injector;

            @Override
            public void preDestroy() {
                Map<Key<?>, Binding<?>> bindings = this.injector.getAllBindings();
                SetMultimap<Binding<?>, Binding<?>> dependants = Multimaps.newSetMultimap(new IdentityHashMap(), new Supplier<Set<Binding<?>>>(){

                    @Override
                    public Set<Binding<?>> get() {
                        return new HashSet();
                    }
                });
                for (Binding<?> binding : bindings.values()) {
                    if (!(binding instanceof HasDependencies)) continue;
                    for (Dependency<?> dependency : ((HasDependencies)((Object)binding)).getDependencies()) {
                        if (!bindings.containsKey(dependency.getKey())) continue;
                        dependants.put(this.injector.getBinding(dependency.getKey()), binding);
                    }
                }
                IdentityHashMap<Object, Object> done = new IdentityHashMap<Object, Object>(bindings.size());
                for (Binding<?> binding : bindings.values()) {
                    if (!new SingletonChecker(binding).isSingleton()) continue;
                    this.close(binding, done, dependants);
                }
                for (Scope scope : this.injector.getScopeBindings().values()) {
                    Jsr250.preDestroy(scope);
                }
            }

            private void close(Binding<?> binding, Map<Object, Object> done, Multimap<Binding<?>, Binding<?>> dependants) {
                if (!done.containsKey(binding)) {
                    done.put(binding, Void.TYPE);
                    for (Binding<?> dependant : dependants.get(binding)) {
                        this.close(dependant, done, dependants);
                    }
                    try {
                        Provider<Object> o;
                        if (binding instanceof ProviderInstanceBinding) {
                            o = ((ProviderInstanceBinding)binding).getProviderInstance();
                            if (!done.containsKey(o)) {
                                Jsr250.preDestroy(o);
                                done.put(o, Void.TYPE);
                            }
                        } else if (new SingletonChecker(binding).isSingleton() && !done.containsKey(o = binding.getProvider().get())) {
                            Jsr250.preDestroy(o);
                            done.put(o, Void.TYPE);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public Jsr250Module addCloseableScopes(Scope ... scopes) {
        this.scopes.addAll(Arrays.asList(scopes));
        return this;
    }

    public Jsr250Module addCloseableScopes(Class<? extends Annotation> ... scopeAnnotations) {
        this.scopeAnnotations.addAll(Arrays.asList(scopeAnnotations));
        return this;
    }

    private class SingletonChecker
    implements BindingScopingVisitor<Boolean> {
        private final Binding<?> binding;

        private SingletonChecker(Binding<?> binding) {
            this.binding = binding;
        }

        boolean isSingleton() {
            return Scopes.isSingleton(this.binding) || this.binding.acceptScopingVisitor(this) != false;
        }

        @Override
        public Boolean visitEagerSingleton() {
            return true;
        }

        @Override
        public Boolean visitScope(Scope scope) {
            return scope.getClass().isAnnotationPresent(Jsr250Singleton.class) || Jsr250Module.this.scopes.contains(scope);
        }

        @Override
        public Boolean visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
            return scopeAnnotation.isAnnotationPresent(Jsr250Singleton.class) || Jsr250Module.this.scopeAnnotations.contains(scopeAnnotation);
        }

        @Override
        public Boolean visitNoScoping() {
            return this.binding instanceof ProviderInstanceBinding || this.binding instanceof InstanceBinding;
        }
    }
}

