/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.redis;

import com.google.inject.Binder;
import com.google.inject.matcher.Matchers;
import com.mycila.inject.redis.Redis;
import com.mycila.inject.redis.RedisCall;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public final class RedisMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = Logger.getLogger(RedisMethodInterceptor.class.getName());
    @Inject
    JedisPool pool;

    private RedisMethodInterceptor() {
    }

    public static void bind(Binder binder) {
        binder.requestStaticInjection(Redis.class);
        RedisMethodInterceptor interceptor = new RedisMethodInterceptor();
        binder.requestInjection(interceptor);
        binder.bindInterceptor(Matchers.any(), Matchers.annotatedWith(RedisCall.class), interceptor);
        binder.bindInterceptor(Matchers.annotatedWith(RedisCall.class), Matchers.any(), interceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        boolean empty = Redis.isEmpty();
        if (empty) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting Redis connection from pool...");
            }
            Redis.set((Jedis)this.pool.getResource());
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (empty) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Returning Redis connection to pool...");
                }
                this.pool.returnResource((Object)Redis.remove());
            }
        }
    }
}

