/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.schedule;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.mycila.inject.internal.guava.collect.ImmutableMap;
import com.mycila.inject.schedule.Cron;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.quartz.CronScheduleBuilder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.TriggerBuilder;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.StdSchedulerFactory;

public final class SchedulingModule
extends AbstractModule {
    private static final Logger LOGGER = Logger.getLogger(SchedulingModule.class.getName());

    @Override
    protected void configure() {
        this.bind(Init.class);
        this.bind(SchedulerFactory.class).to(StdSchedulerFactory.class).in(Singleton.class);
        this.bindListener(new AbstractMatcher<TypeLiteral<?>>(){

            @Override
            public boolean matches(TypeLiteral<?> type) {
                return type.getRawType().isAnnotationPresent(Cron.class) && Runnable.class.isAssignableFrom(type.getRawType());
            }
        }, new TypeListener(){

            @Override
            public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                final Provider<Scheduler> scheduler = encounter.getProvider(Scheduler.class);
                encounter.register(new InjectionListener<I>(){

                    @Override
                    public void afterInjection(I injectee) {
                        Cron cron = injectee.getClass().getAnnotation(Cron.class);
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("Registering cron job " + injectee.getClass().getName() + " at frequency: " + cron.value());
                        }
                        try {
                            ((Scheduler)scheduler.get()).addJob(JobBuilder.newJob(QuartzAdapter.class).storeDurably().withIdentity(injectee.getClass().getName() + "-job", SchedulingModule.this.getClass().getSimpleName()).usingJobData(new JobDataMap(ImmutableMap.of(QuartzAdapter.class.getName(), injectee))).requestRecovery(true).build(), true);
                            ((Scheduler)scheduler.get()).scheduleJob(TriggerBuilder.newTrigger().withIdentity(injectee.getClass().getName() + "-trigger", SchedulingModule.this.getClass().getSimpleName()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron.value())).forJob(injectee.getClass().getName() + "-job", SchedulingModule.this.getClass().getSimpleName()).build());
                        }
                        catch (SchedulerException e) {
                            throw new ProvisionException(e.getMessage(), e);
                        }
                    }
                });
            }
        });
    }

    @Provides
    @Singleton
    Scheduler scheduler(SchedulerFactory schedulerFactory) throws SchedulerException {
        Scheduler scheduler = schedulerFactory.getScheduler();
        if (!scheduler.isStarted()) {
            scheduler.start();
        }
        return scheduler;
    }

    @DisallowConcurrentExecution
    public static final class QuartzAdapter
    implements InterruptableJob {
        private AtomicReference<Thread> runningThread = new AtomicReference();

        public void interrupt() throws UnableToInterruptJobException {
            Thread running = this.runningThread.get();
            if (running != null) {
                running.interrupt();
            }
        }

        public void execute(JobExecutionContext context) throws JobExecutionException {
            Runnable job = (Runnable)context.getJobDetail().getJobDataMap().get((Object)QuartzAdapter.class.getName());
            if (job == null) {
                throw new JobExecutionException("Job not found !");
            }
            if (this.runningThread.compareAndSet(null, Thread.currentThread())) {
                try {
                    job.run();
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.SEVERE, "Error in job " + job.getClass().getName() + " : " + e.getMessage(), e);
                    throw new JobExecutionException(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.runningThread.set(null);
                }
            } else {
                throw new JobExecutionException("Illegal invocation: job is already running from thread: " + this.runningThread.get().getName());
            }
        }
    }

    @Singleton
    static class Init {
        @Inject
        Scheduler scheduler;

        Init() {
        }

        @PreDestroy
        void close() throws SchedulerException {
            LOGGER.info("Closing scheduler...");
            this.scheduler.shutdown();
            LOGGER.info("Closed !");
        }
    }
}

