/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.scope;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.mycila.inject.annotation.Jsr250Singleton;
import com.mycila.inject.jsr250.Jsr250;
import com.mycila.inject.scope.MycilaScope;
import java.util.concurrent.TimeUnit;

@Jsr250Singleton
public final class ExpiringSingleton
extends MycilaScope {
    private static final Object NULL = new Object();
    final long expirationDelay;

    public ExpiringSingleton(long expirationDelay, TimeUnit unit) {
        this.expirationDelay = unit.toMillis(expirationDelay);
    }

    @Override
    public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
        return new Provider<T>(){
            private volatile T instance;
            private volatile long expirationTime;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (this.instance == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.instance == null) {
                            this.instance = creator.get();
                            this.expirationTime = System.currentTimeMillis() + ExpiringSingleton.this.expirationDelay;
                        }
                    }
                }
                if (this.instance != NULL && this.expirationTime < System.currentTimeMillis()) {
                    Object old = this.instance;
                    this.instance = NULL;
                    if (ExpiringSingleton.this.hasJSR250Module) {
                        Jsr250.preDestroy(old);
                    }
                }
                return this.instance == NULL ? null : (Object)this.instance;
            }

            public String toString() {
                return String.format("%s[%s]", creator, ExpiringSingleton.this);
            }
        };
    }
}

