/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.scope;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.mycila.inject.scope.MycilaScope;
import java.lang.ref.Reference;

abstract class RefScope
extends MycilaScope {
    static final Object NULL = new Object();

    RefScope() {
    }

    @Override
    public final <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
        return new Provider<T>(){
            private volatile Reference<T> ref;

            @Override
            public T get() {
                return this.ref == null ? this.newRef(creator) : this.fromRef(creator);
            }

            private T fromRef(Provider<T> unscoped) {
                Object instance = this.ref.get();
                if (instance == NULL) {
                    return null;
                }
                if (instance != null) {
                    return instance;
                }
                return this.newRef(unscoped);
            }

            private T newRef(Provider<T> unscoped) {
                Object instance = unscoped.get();
                this.ref = RefScope.this.build(instance == null ? NULL : instance);
                return instance;
            }

            public String toString() {
                return String.format("%s[%s]", creator, RefScope.this);
            }
        };
    }

    protected abstract <T> Reference<T> build(T var1);
}

