/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.service;

import com.mycila.inject.util.DefaultLoader;
import com.mycila.inject.util.Loader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;

public final class ServiceClassLoader<S>
implements Iterable<Class<S>> {
    private static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private final Loader loader;
    private LinkedHashMap<String, Class<S>> providers = new LinkedHashMap();
    private LazyIterator lookupIterator;

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private ServiceClassLoader(Class<S> svc, Loader loader) {
        this.service = svc;
        this.loader = loader;
        this.reload();
    }

    private static void fail(Class service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceClassLoader.fail(service, u + ":" + line + ": " + msg);
    }

    private int parseLine(Class service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceClassLoader.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceClassLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceClassLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.providers.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> parse(Class service, URL u) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceClassLoader.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceClassLoader.fail(service, "Error closing configuration file", y);
            }
        }
        return names.iterator();
    }

    @Override
    public Iterator<Class<S>> iterator() {
        return new Iterator<Class<S>>(){
            Iterator<Map.Entry<String, Class<S>>> knownProviders;
            {
                this.knownProviders = ServiceClassLoader.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.knownProviders.hasNext() || ServiceClassLoader.this.lookupIterator.hasNext();
            }

            @Override
            public Class<S> next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                return ServiceClassLoader.this.lookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceClassLoader<S> load(Class<S> service, Loader loader) {
        return new ServiceClassLoader<S>(service, loader);
    }

    public static <S> ServiceClassLoader<S> load(Class<S> service) {
        return new ServiceClassLoader<S>(service, new DefaultLoader());
    }

    public String toString() {
        return "ServiceClassLoader[" + this.service.getName() + "]";
    }

    private class LazyIterator
    implements Iterator<Class<S>> {
        final Class<? super S> service;
        final Loader loader;
        Iterator<URL> configs = null;
        Iterator<String> pending = null;
        String nextName = null;

        private LazyIterator(Class<? super S> service, Loader loader) {
            this.service = service;
            this.loader = loader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                String fullName = ServiceClassLoader.PREFIX + this.service.getName();
                this.configs = this.loader.getResources(fullName).iterator();
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasNext()) {
                    return false;
                }
                this.pending = ServiceClassLoader.this.parse(this.service, this.configs.next());
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public Class<S> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            try {
                Class<?> p = this.loader.loadClass(cn);
                ServiceClassLoader.this.providers.put(cn, p);
                return p;
            }
            catch (RuntimeException x) {
                ServiceClassLoader.fail(this.service, "Provider " + cn + " could not be instantiated: " + x, x);
                throw new Error();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

