/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.service;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Types;
import com.mycila.inject.service.ServiceLoaderProvider;
import com.mycila.inject.util.Loader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public final class ServiceLoaderModule<T>
implements Module {
    private final Key<T[]> listKey;
    private Key<? extends Loader> loaderKey;

    private ServiceLoaderModule(Key<T[]> listKey) {
        this.listKey = listKey;
    }

    public ServiceLoaderModule<T> withLoader(Class<? extends Loader> loaderType) {
        return this.withLoader(Key.get(loaderType));
    }

    public ServiceLoaderModule<T> withLoader(Class<? extends Loader> loaderType, Class<? extends Annotation> annot) {
        return this.withLoader(Key.get(loaderType, annot));
    }

    public ServiceLoaderModule<T> withLoader(Class<? extends Loader> loaderType, Annotation annot) {
        return this.withLoader(Key.get(loaderType, annot));
    }

    public ServiceLoaderModule<T> withLoader(Key<? extends Loader> key) {
        this.loaderKey = key;
        return this;
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(this.listKey).toProvider(ServiceLoaderProvider.of(this.getType()).withLoader(this.loaderKey));
    }

    private Class<T> getType() {
        return this.listKey.getTypeLiteral().getRawType().getComponentType();
    }

    public static <T> Module of(Class<T> serviceClass) {
        return new ServiceLoaderModule<T>(Key.get(Types.arrayOf(serviceClass)));
    }

    public static <T> Module of(Class<T> serviceClass, Annotation annotation) {
        return new ServiceLoaderModule<T>(Key.get((Type)Types.arrayOf(serviceClass), annotation));
    }

    public static <T> Module of(Class<T> serviceClass, Class<? extends Annotation> annotationType) {
        return new ServiceLoaderModule<T>(Key.get((Type)Types.arrayOf(serviceClass), annotationType));
    }
}

