/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import java.io.File;

public enum FileType {
    REQUEST,
    RESPONSE,
    ARCHIVE,
    HISTORY;

    public static final String REQUEST_EXT = ".rcq";
    public static final String RESPONSE_EXT = ".rcs";
    public static final String ARCHIVE_EXT = ".rcr";
    public static final String HISTORY_EXT = ".rch";

    public String getExtension() {
        switch (this) {
            case REQUEST: {
                return REQUEST_EXT;
            }
            case RESPONSE: {
                return RESPONSE_EXT;
            }
            case ARCHIVE: {
                return ARCHIVE_EXT;
            }
            case HISTORY: {
                return HISTORY_EXT;
            }
        }
        return null;
    }

    public static boolean isRequest(File f) {
        String path = f.getAbsolutePath();
        return (path = path.toLowerCase()).endsWith(REQUEST_EXT);
    }

    public static boolean isResponse(File f) {
        String path = f.getAbsolutePath();
        return (path = path.toLowerCase()).endsWith(RESPONSE_EXT);
    }

    public static boolean isArchive(File f) {
        String path = f.getAbsolutePath();
        return (path = path.toLowerCase()).endsWith(ARCHIVE_EXT);
    }

    public static boolean isHistory(File f) {
        String path = f.getAbsolutePath();
        return (path = path.toLowerCase()).endsWith(HISTORY_EXT);
    }

    public static String getType(File f) {
        String path = f.getAbsolutePath();
        path = path.toLowerCase();
        String type = null;
        if (path.endsWith(REQUEST_EXT)) {
            type = REQUEST_EXT;
        } else if (path.endsWith(RESPONSE_EXT)) {
            type = RESPONSE_EXT;
        } else if (path.endsWith(ARCHIVE_EXT)) {
            type = ARCHIVE_EXT;
        } else if (path.endsWith(HISTORY_EXT)) {
            type = HISTORY_EXT;
        }
        return type;
    }

    public static File getWithExtension(File f, FileType type) {
        if (f == null) {
            return null;
        }
        if (f.getAbsolutePath().toLowerCase().endsWith(type.getExtension())) {
            return f;
        }
        return new File(f.getParent(), f.getName() + type.getExtension());
    }
}

