/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.wiztools.restclient.IGlobalOptions;

@Singleton
public final class GlobalOptions
implements IGlobalOptions {
    private static final Logger LOG = Logger.getLogger(GlobalOptions.class.getName());
    public static final Integer DEFAULT_TIMEOUT_MILLIS = new Integer(60000);
    private static final File CONF_PROPERTY = new File(CONF_DIR, "rest-client.properties");
    private final Properties prop = new Properties();
    Lock lock = new ReentrantLock();
    private int requestTimeoutInMillis;

    public int getRequestTimeoutInMillis() {
        return this.requestTimeoutInMillis;
    }

    public void setRequestTimeoutInMillis(int requestTimeoutInMillis) {
        this.requestTimeoutInMillis = requestTimeoutInMillis;
    }

    public GlobalOptions() {
        this.prop.setProperty("request-timeout-in-millis", "60000");
        if (!CONF_DIR.exists()) {
            LOG.info("Configuration directory does not exist. Creating...");
            CONF_DIR.mkdir();
        }
        if (CONF_PROPERTY.exists()) {
            try {
                this.prop.load(new FileInputStream(CONF_PROPERTY));
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Failed loading default properties!", ex);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                GlobalOptions.this.writeProperties();
            }
        }));
    }

    @Override
    public void setProperty(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.prop.setProperty(key, value);
    }

    @Override
    public void removeProperty(String key) {
        this.prop.remove(key);
    }

    @Override
    public String getProperty(String key) {
        return this.prop.getProperty(key);
    }

    @Override
    public boolean isPropertyTrue(String key) {
        String value = this.prop.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    @Override
    public void writeProperties() {
        try {
            FileOutputStream os = new FileOutputStream(CONF_PROPERTY);
            this.prop.store(os, "RESTClient Properties");
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Error writing to properties!", ex);
        }
    }

    @Override
    public void acquire() {
        this.lock.lock();
    }

    @Override
    public void release() {
        this.lock.unlock();
    }
}

