/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestSuite;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.StreamUtil;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.HTTPClientUtil;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.MultipleRequestInSameRequestExecuterException;
import org.wiztools.restclient.ProxyConfig;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.TestUtil;
import org.wiztools.restclient.View;
import org.wiztools.restclient.bean.Auth;
import org.wiztools.restclient.bean.AuthorizationHeaderAuth;
import org.wiztools.restclient.bean.BasicAuth;
import org.wiztools.restclient.bean.BasicDigestAuth;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.DigestAuth;
import org.wiztools.restclient.bean.HTTPMethod;
import org.wiztools.restclient.bean.HTTPVersion;
import org.wiztools.restclient.bean.NtlmAuth;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityFilePart;
import org.wiztools.restclient.bean.ReqEntityMultipart;
import org.wiztools.restclient.bean.ReqEntityPart;
import org.wiztools.restclient.bean.ReqEntitySimple;
import org.wiztools.restclient.bean.ReqEntityStringPart;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.RequestExecuter;
import org.wiztools.restclient.bean.ResponseBean;
import org.wiztools.restclient.bean.SSLHostnameVerifier;
import org.wiztools.restclient.bean.SSLReq;
import org.wiztools.restclient.bean.TestException;
import org.wiztools.restclient.bean.TestResult;
import org.wiztools.restclient.bean.UsernamePasswordAuth;
import org.wiztools.restclient.http.EntityEnclosingDelete;
import org.wiztools.restclient.http.NoValidationCookieSpecFactory;
import org.wiztools.restclient.http.RESTClientCookieStore;
import org.wiztools.restclient.util.HttpUtil;
import org.wiztools.restclient.util.IDNUtil;
import org.wiztools.restclient.util.Util;

public class HTTPClientRequestExecuter
implements RequestExecuter {
    private static final Logger LOG = Logger.getLogger(HTTPClientRequestExecuter.class.getName());
    private DefaultHttpClient httpclient;
    private boolean interruptedShutdown = false;
    private boolean isRequestCompleted = false;
    private boolean isRequestStarted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Request request, View ... views) {
        if (this.isRequestStarted) {
            throw new MultipleRequestInSameRequestExecuterException("A RequestExecuter object can be used only once!");
        }
        this.isRequestStarted = true;
        for (View view : views) {
            view.doStart(request);
        }
        URL url = IDNUtil.getIDNizedURL(request.getUrl());
        String urlHost = url.getHost();
        int urlPort = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        String urlProtocol = url.getProtocol();
        String urlStr = url.toString();
        BasicHttpContext httpContext = null;
        this.httpclient = new DefaultHttpClient();
        HTTPVersion httpVersion = request.getHttpVersion();
        ProtocolVersion protocolVersion = httpVersion == HTTPVersion.HTTP_1_1 ? new ProtocolVersion("HTTP", 1, 1) : new ProtocolVersion("HTTP", 1, 0);
        this.httpclient.getParams().setParameter("http.protocol.version", protocolVersion);
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        options.acquire();
        HttpConnectionParams.setConnectionTimeout(this.httpclient.getParams(), Integer.parseInt(options.getProperty("request-timeout-in-millis")));
        options.release();
        ProxyConfig proxy = ProxyConfig.getInstance();
        proxy.acquire();
        if (proxy.isEnabled()) {
            HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort(), "http");
            if (proxy.isAuthEnabled()) {
                this.httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), new UsernamePasswordCredentials(proxy.getUsername(), new String(proxy.getPassword())));
            }
            this.httpclient.getParams().setParameter("http.route.default-proxy", proxyHost);
        }
        proxy.release();
        if (request.getAuth() != null) {
            String pwd;
            String uid;
            UsernamePasswordAuth a;
            Auth auth = request.getAuth();
            ArrayList<String> authPrefs = new ArrayList<String>();
            if (auth instanceof BasicAuth) {
                authPrefs.add("Basic");
            } else if (auth instanceof DigestAuth) {
                authPrefs.add("Digest");
            } else if (auth instanceof NtlmAuth) {
                authPrefs.add("NTLM");
            }
            this.httpclient.getParams().setParameter("http.auth.target-scheme-pref", authPrefs);
            if (auth instanceof BasicAuth || auth instanceof DigestAuth) {
                a = (BasicDigestAuth)auth;
                uid = a.getUsername();
                pwd = new String(a.getPassword());
                String host = StringUtil.isEmpty(a.getHost()) ? urlHost : a.getHost();
                String realm = StringUtil.isEmpty(a.getRealm()) ? AuthScope.ANY_REALM : a.getRealm();
                this.httpclient.getCredentialsProvider().setCredentials(new AuthScope(host, urlPort, realm), new UsernamePasswordCredentials(uid, pwd));
                if (a.isPreemptive()) {
                    BasicAuthCache authCache = new BasicAuthCache();
                    RFC2617Scheme authScheme = a instanceof BasicAuth ? new BasicScheme() : new DigestScheme();
                    authCache.put(new HttpHost(urlHost, urlPort, urlProtocol), authScheme);
                    BasicHttpContext localcontext = new BasicHttpContext();
                    localcontext.setAttribute("http.auth.auth-cache", authCache);
                    httpContext = localcontext;
                }
            }
            if (auth instanceof NtlmAuth) {
                a = (NtlmAuth)auth;
                uid = a.getUsername();
                pwd = new String(a.getPassword());
                this.httpclient.getCredentialsProvider().setCredentials(AuthScope.ANY, new NTCredentials(uid, pwd, a.getWorkstation(), a.getDomain()));
            }
        }
        HttpRequestBase method = null;
        HTTPMethod httpMethod = request.getMethod();
        try {
            ResponseBean response;
            block81: {
                Charset c;
                SSLReq sslReq;
                AuthorizationHeaderAuth a;
                String authHeader;
                switch (httpMethod) {
                    case GET: {
                        method = new HttpGet(urlStr);
                        break;
                    }
                    case POST: {
                        method = new HttpPost(urlStr);
                        break;
                    }
                    case PUT: {
                        method = new HttpPut(urlStr);
                        break;
                    }
                    case PATCH: {
                        method = new HttpPatch(urlStr);
                        break;
                    }
                    case DELETE: {
                        method = new EntityEnclosingDelete(urlStr);
                        break;
                    }
                    case HEAD: {
                        method = new HttpHead(urlStr);
                        break;
                    }
                    case OPTIONS: {
                        method = new HttpOptions(urlStr);
                        break;
                    }
                    case TRACE: {
                        method = new HttpTrace(urlStr);
                    }
                }
                method.setParams(new BasicHttpParams().setParameter(urlStr, url));
                Auth auth = request.getAuth();
                if (auth != null && auth instanceof AuthorizationHeaderAuth && StringUtil.isNotEmpty(authHeader = (a = (AuthorizationHeaderAuth)auth).getAuthorizationHeaderValue())) {
                    BasicHeader header = new BasicHeader("Authorization", authHeader);
                    method.addHeader(header);
                }
                MultiValueMap<String, String> header_data = request.getHeaders();
                for (String key : header_data.keySet()) {
                    for (String value : header_data.get(key)) {
                        BasicHeader header = new BasicHeader(key, value);
                        method.addHeader(header);
                    }
                }
                this.httpclient.getCookieSpecs().register("RESTClient_Cookie_Spec", new NoValidationCookieSpecFactory());
                this.httpclient.getParams().setParameter("http.protocol.cookie-policy", "RESTClient_Cookie_Spec");
                RESTClientCookieStore store = new RESTClientCookieStore();
                List<HttpCookie> cookies = request.getCookies();
                for (HttpCookie cookie : cookies) {
                    BasicClientCookie c2 = new BasicClientCookie(cookie.getName(), cookie.getValue());
                    c2.setVersion(cookie.getVersion());
                    c2.setDomain(urlHost);
                    c2.setPath("/");
                    store.addCookie(c2);
                }
                this.httpclient.setCookieStore(store);
                if (method instanceof HttpEntityEnclosingRequest) {
                    HttpEntityEnclosingRequest eeMethod = (HttpEntityEnclosingRequest)((Object)method);
                    ReqEntity bean = request.getBody();
                    if (bean != null) {
                        try {
                            if (bean instanceof ReqEntitySimple) {
                                AbstractHttpEntity e = HTTPClientUtil.getEntity((ReqEntitySimple)bean);
                                eeMethod.setEntity(e);
                            } else if (bean instanceof ReqEntityMultipart) {
                                ReqEntityMultipart multipart = (ReqEntityMultipart)bean;
                                MultipartEntity me = new MultipartEntity();
                                for (ReqEntityPart part : multipart.getBody()) {
                                    ContentType ct;
                                    Object body;
                                    ReqEntityPart p;
                                    if (part instanceof ReqEntityStringPart) {
                                        p = (ReqEntityStringPart)part;
                                        body = p.getPart();
                                        ct = p.getContentType();
                                        StringBody sb = null;
                                        sb = ct != null ? new StringBody((String)body, ct.getContentType(), HttpUtil.getCharsetDefault(ct)) : new StringBody((String)body);
                                        me.addPart(part.getName(), sb);
                                        continue;
                                    }
                                    if (!(part instanceof ReqEntityFilePart)) continue;
                                    p = (ReqEntityFilePart)part;
                                    body = p.getPart();
                                    ct = p.getContentType();
                                    FileBody fb = null;
                                    fb = ct != null ? new FileBody((File)body, ct.getContentType(), HttpUtil.getCharsetDefault(ct).name()) : new FileBody((File)body);
                                    me.addPart(part.getName(), fb);
                                }
                                eeMethod.setEntity(me);
                            }
                        }
                        catch (UnsupportedEncodingException ex) {
                            for (View view : views) {
                                view.doError(Util.getStackTrace(ex));
                                view.doEnd();
                            }
                            if (method != null && !this.interruptedShutdown) {
                                this.httpclient.getConnectionManager().shutdown();
                            }
                            for (View view : views) {
                                view.doEnd();
                            }
                            this.isRequestCompleted = true;
                            return;
                        }
                    }
                }
                if ((sslReq = request.getSslReq()) != null) {
                    X509HostnameVerifier hcVerifier;
                    SSLHostnameVerifier verifier = sslReq.getHostNameVerifier();
                    switch (verifier) {
                        case STRICT: {
                            hcVerifier = SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
                            break;
                        }
                        case BROWSER_COMPATIBLE: {
                            hcVerifier = SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
                            break;
                        }
                        case ALLOW_ALL: {
                            hcVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                            break;
                        }
                        default: {
                            hcVerifier = SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
                        }
                    }
                    String trustStorePath = sslReq.getTrustStore();
                    String keyStorePath = sslReq.getKeyStore();
                    KeyStore trustStore = StringUtil.isEmpty(trustStorePath) ? null : this.getKeyStore(trustStorePath, sslReq.getTrustStorePassword());
                    KeyStore keyStore = StringUtil.isEmpty(keyStorePath) ? null : this.getKeyStore(keyStorePath, sslReq.getKeyStorePassword());
                    TrustSelfSignedStrategy trustStrategy = sslReq.isTrustSelfSignedCert() ? new TrustSelfSignedStrategy() : null;
                    SSLSocketFactory socketFactory = new SSLSocketFactory("TLS", keyStore, sslReq.getKeyStorePassword() != null ? new String(sslReq.getKeyStorePassword()) : null, trustStore, null, trustStrategy, hcVerifier);
                    Scheme sch = new Scheme(urlProtocol, urlPort, socketFactory);
                    this.httpclient.getConnectionManager().getSchemeRegistry().register(sch);
                }
                this.httpclient.setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler());
                this.httpclient.getParams().setParameter("http.protocol.handle-redirects", request.isFollowRedirect());
                long startTime = System.currentTimeMillis();
                HttpResponse http_res = this.httpclient.execute((HttpUriRequest)method, httpContext);
                long endTime = System.currentTimeMillis();
                response = new ResponseBean();
                response.setExecutionTime(endTime - startTime);
                response.setStatusCode(http_res.getStatusLine().getStatusCode());
                response.setStatusLine(http_res.getStatusLine().toString());
                Header[] responseHeaders = http_res.getAllHeaders();
                String contentType = null;
                for (Header header : responseHeaders) {
                    response.addHeader(header.getName(), header.getValue());
                    if (!header.getName().equalsIgnoreCase("content-type")) continue;
                    contentType = header.getValue();
                }
                if (contentType != null) {
                    String charsetStr = HttpUtil.getCharsetFromContentType(contentType);
                    try {
                        c = Charset.forName(charsetStr);
                    }
                    catch (IllegalCharsetNameException ex) {
                        LOG.log(Level.WARNING, "Charset name is illegal: {0}", charsetStr);
                        c = Charset.defaultCharset();
                    }
                    catch (UnsupportedCharsetException ex) {
                        LOG.log(Level.WARNING, "Charset {0} is not supported in this JVM.", charsetStr);
                        c = Charset.defaultCharset();
                    }
                    catch (IllegalArgumentException ex) {
                        LOG.log(Level.WARNING, "Charset parameter is not available in Content-Type header!");
                        c = Charset.defaultCharset();
                    }
                } else {
                    c = Charset.defaultCharset();
                    LOG.log(Level.WARNING, "Content-Type header not available in response. Using platform default encoding: {0}", c.name());
                }
                Charset charset = c;
                HttpEntity entity = http_res.getEntity();
                if (entity != null) {
                    if (request.isIgnoreResponseBody()) {
                        EntityUtils.consumeQuietly(entity);
                    } else {
                        InputStream is = entity.getContent();
                        try {
                            byte[] responseBody = StreamUtil.inputStream2Bytes(is);
                            if (responseBody != null) {
                                response.setResponseBody(responseBody);
                            }
                        }
                        catch (IOException ex) {
                            for (View view : views) {
                                view.doError("Byte array conversion from response body stream failed.");
                            }
                            LOG.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    }
                }
                try {
                    TestSuite suite = TestUtil.getTestSuite(request, response);
                    if (suite == null) break block81;
                    TestResult testResult = TestUtil.execute(suite);
                    response.setTestResult(testResult);
                }
                catch (TestException ex) {
                    for (View view : views) {
                        view.doError(Util.getStackTrace(ex));
                    }
                }
            }
            for (View view : views) {
                view.doResponse(response);
            }
        }
        catch (IOException ex) {
            if (!this.interruptedShutdown) {
                for (View view : views) {
                    view.doError(Util.getStackTrace(ex));
                }
            } else {
                for (View view : views) {
                    view.doCancelled();
                }
            }
        }
        catch (Exception ex) {
            if (!this.interruptedShutdown) {
                for (View view : views) {
                    view.doError(Util.getStackTrace(ex));
                }
            } else {
                for (View view : views) {
                    view.doCancelled();
                }
            }
        }
        finally {
            if (method != null && !this.interruptedShutdown) {
                this.httpclient.getConnectionManager().shutdown();
            }
            for (View view : views) {
                view.doEnd();
            }
            this.isRequestCompleted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore(String storePath, char[] storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
        if (StringUtil.isNotEmpty(storePath)) {
            FileInputStream instream = new FileInputStream(new File(storePath));
            try {
                store.load(instream, storePassword);
            }
            finally {
                instream.close();
            }
        }
        return store;
    }

    @Override
    public void abortExecution() {
        if (!this.isRequestCompleted) {
            ClientConnectionManager conMgr = this.httpclient.getConnectionManager();
            this.interruptedShutdown = true;
            conMgr.shutdown();
        } else {
            LOG.info("Request already completed. Doing nothing.");
        }
    }
}

