/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.bean;

import java.net.HttpCookie;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wiztools.commons.CollectionsUtil;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.MultiValueMapArrayList;
import org.wiztools.restclient.bean.Auth;
import org.wiztools.restclient.bean.HTTPMethod;
import org.wiztools.restclient.bean.HTTPVersion;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityStringBean;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.SSLReq;

public final class RequestBean
implements Request {
    private URL url;
    private HTTPMethod method;
    private Auth auth;
    private final MultiValueMap<String, String> headers = new MultiValueMapArrayList<String, String>();
    private final List<HttpCookie> cookies = new ArrayList<HttpCookie>();
    private ReqEntity body;
    private String testScript;
    private SSLReq sslReq;
    private HTTPVersion httpVersion = HTTPVersion.getDefault();
    private boolean isFollowRedirect;
    private boolean isIgnoreResponseBody = false;

    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    @Override
    public Auth getAuth() {
        return this.auth;
    }

    @Override
    public SSLReq getSslReq() {
        return this.sslReq;
    }

    public void setSslReq(SSLReq sslReq) {
        this.sslReq = sslReq;
    }

    @Override
    public HTTPVersion getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(HTTPVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    @Override
    public String getTestScript() {
        return this.testScript;
    }

    public void setTestScript(String testScript) {
        this.testScript = testScript;
    }

    @Override
    public ReqEntity getBody() {
        return this.body;
    }

    public void setBody(ReqEntity body) {
        this.body = body;
    }

    @Override
    public MultiValueMap<String, String> getHeaders() {
        return CollectionsUtil.unmodifiableMultiValueMap(this.headers);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addCookie(HttpCookie cookie) {
        this.cookies.add(cookie);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return Collections.unmodifiableList(this.cookies);
    }

    @Override
    public HTTPMethod getMethod() {
        return this.method;
    }

    public void setMethod(HTTPMethod method) {
        this.method = method;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public boolean isFollowRedirect() {
        return this.isFollowRedirect;
    }

    public void setFollowRedirect(boolean isFollowRedirect) {
        this.isFollowRedirect = isFollowRedirect;
    }

    public void setIgnoreResponseBody(boolean isIgnoreResponseBody) {
        this.isIgnoreResponseBody = isIgnoreResponseBody;
    }

    @Override
    public boolean isIgnoreResponseBody() {
        return this.isIgnoreResponseBody;
    }

    @Override
    public Object clone() {
        RequestBean cloned = new RequestBean();
        cloned.setSslReq(this.sslReq);
        cloned.setHttpVersion(this.httpVersion);
        if (this.body != null) {
            cloned.setBody((ReqEntityStringBean)this.body.clone());
        }
        if (!this.headers.isEmpty()) {
            for (String header : this.headers.keySet()) {
                for (String value : this.headers.get(header)) {
                    cloned.addHeader(header, value);
                }
            }
        }
        if (!this.cookies.isEmpty()) {
            for (HttpCookie cookie : this.cookies) {
                cloned.addCookie(cookie);
            }
        }
        cloned.setMethod(this.method);
        cloned.setTestScript(this.testScript);
        cloned.setUrl(this.url);
        cloned.setFollowRedirect(this.isFollowRedirect);
        cloned.setIgnoreResponseBody(this.isIgnoreResponseBody);
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestBean other = (RequestBean)obj;
        if (!(this.url == other.url || this.url != null && this.url.equals(other.url))) {
            return false;
        }
        if (this.method != other.method) {
            return false;
        }
        if (!(this.auth == other.auth || this.auth != null && this.auth.equals(other.auth))) {
            return false;
        }
        if (!(this.headers == other.headers || this.headers != null && this.headers.equals(other.headers))) {
            return false;
        }
        if (!(this.cookies == other.cookies || this.cookies != null && this.cookies.equals(other.cookies))) {
            return false;
        }
        if (!(this.body == other.body || this.body != null && this.body.equals(other.body))) {
            return false;
        }
        if (this.testScript == null ? other.testScript != null : !this.testScript.equals(other.testScript)) {
            return false;
        }
        if (!(this.sslReq == other.sslReq || this.sslReq != null && this.sslReq.equals(other.sslReq))) {
            return false;
        }
        if (this.httpVersion != other.httpVersion) {
            return false;
        }
        if (this.isFollowRedirect != other.isFollowRedirect) {
            return false;
        }
        return this.isIgnoreResponseBody == other.isIgnoreResponseBody;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.url != null ? this.url.hashCode() : 0);
        hash = 23 * hash + (this.method != null ? this.method.hashCode() : 0);
        hash = 23 * hash + (this.auth != null ? this.auth.hashCode() : 0);
        hash = 23 * hash + (this.headers != null ? this.headers.hashCode() : 0);
        hash = 23 * hash + (this.cookies != null ? this.cookies.hashCode() : 0);
        hash = 23 * hash + (this.body != null ? this.body.hashCode() : 0);
        hash = 23 * hash + (this.testScript != null ? this.testScript.hashCode() : 0);
        hash = 23 * hash + (this.sslReq != null ? this.sslReq.hashCode() : 0);
        hash = 23 * hash + (this.httpVersion != null ? this.httpVersion.hashCode() : 0);
        hash = 23 * hash + (this.isFollowRedirect ? 1 : 0);
        hash = 23 * hash + (this.isIgnoreResponseBody ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@Request[");
        sb.append(this.url).append(", ");
        sb.append((Object)this.method).append(", ");
        sb.append(this.headers).append(", ");
        sb.append(this.cookies).append(", ");
        sb.append(this.body).append(", ");
        sb.append(this.auth).append(", ");
        sb.append(this.sslReq).append(", ");
        sb.append((Object)this.httpVersion).append(", ");
        sb.append(this.isFollowRedirect).append(", ");
        sb.append(this.isIgnoreResponseBody).append(", ");
        sb.append(this.testScript);
        sb.append("]");
        return sb.toString();
    }
}

