/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.wiztools.restclient.XMLException;
import org.wiztools.restclient.bean.ReqResBean;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.ui.RESTViewImpl;
import org.wiztools.restclient.util.Util;
import org.wiztools.restclient.util.XMLUtil;

class FileOpenUtil {
    private FileOpenUtil() {
    }

    static void openRequest(RESTViewImpl view, File f) {
        Exception e = null;
        try {
            Request request = XMLUtil.getRequestFromXMLFile(f);
            view.setUIFromRequest(request);
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (XMLException ex) {
            e = ex;
        }
        if (e != null) {
            view.showError(Util.getStackTrace(e));
        }
    }

    static void openResponse(RESTViewImpl view, File f) {
        Exception e = null;
        try {
            Response response = XMLUtil.getResponseFromXMLFile(f);
            view.setUIFromResponse(response);
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (XMLException ex) {
            e = ex;
        }
        if (e != null) {
            view.showError(Util.getStackTrace(e));
        }
    }

    static void openArchive(RESTViewImpl view, File f) {
        Exception e = null;
        try {
            ReqResBean encp = Util.getReqResArchive(f);
            Request request = encp.getRequestBean();
            Response response = encp.getResponseBean();
            if (request != null && response != null) {
                view.setUIFromRequest(request);
                view.setUIFromResponse(response);
            } else {
                view.showError("Unable to load archive! Check if valid archive!");
            }
        }
        catch (IOException ex) {
            e = ex;
        }
        catch (XMLException ex) {
            e = ex;
        }
        if (e != null) {
            view.showError(Util.getStackTrace(e));
        }
    }

    static void open(RESTViewImpl view, File f) {
        String fileName = f.getName().toLowerCase();
        if (fileName.endsWith(".rcq")) {
            FileOpenUtil.openRequest(view, f);
        } else if (fileName.endsWith(".rcs")) {
            FileOpenUtil.openResponse(view, f);
        } else if (fileName.endsWith(".rcr")) {
            FileOpenUtil.openArchive(view, f);
        } else {
            JOptionPane.showMessageDialog(view.getContainer(), "File in unrecognized format!", "File in unrecognized format!", 0);
        }
    }
}

