/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.FileUtil;
import org.wiztools.restclient.MessageI18N;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.MultiEntryAdd;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.util.Util;

class KeyValMultiEntryDialog
extends EscapableDialog {
    private JButton jb_file = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private JButton jb_help = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/question.png"));
    private JButton jb_add = new JButton("Add");
    private JButton jb_cancel = new JButton("Cancel");
    private JScrollPane jsp_in;
    private JTextArea jta_in = new JTextArea(18, 35);
    private JDialog me;
    private RESTUserInterface ui;
    private MultiEntryAdd callback;

    public KeyValMultiEntryDialog(RESTUserInterface ui, MultiEntryAdd callback) {
        super((Frame)ui.getFrame(), true);
        this.ui = ui;
        this.me = this;
        this.setTitle("Multi-entry");
        this.callback = callback;
        this.init();
    }

    private void init() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        JPanel jp_north = new JPanel();
        jp_north.setLayout(new FlowLayout(0));
        this.jb_file.setToolTipText("Load from file");
        this.jb_file.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyValMultiEntryDialog.this.loadFromFile();
            }
        });
        jp_north.add(this.jb_file);
        this.jb_help.setToolTipText("Help");
        this.jb_help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(KeyValMultiEntryDialog.this.me, MessageI18N.getMessage("help.keyval.multi"), "Help", 1);
            }
        });
        jp_north.add(this.jb_help);
        jp.add((Component)jp_north, "North");
        this.jsp_in = new JScrollPane(this.jta_in);
        jp.add((Component)this.jsp_in, "Center");
        JPanel jp_south = new JPanel();
        jp_south.setLayout(new FlowLayout());
        this.jb_add.setMnemonic('a');
        this.getRootPane().setDefaultButton(this.jb_add);
        this.jb_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                KeyValMultiEntryDialog.this.add();
            }
        });
        jp_south.add(this.jb_add);
        this.jb_cancel.setMnemonic('c');
        this.jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                KeyValMultiEntryDialog.this.me.setVisible(false);
            }
        });
        jp_south.add(this.jb_cancel);
        jp.add((Component)jp_south, "South");
        jp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(jp);
        this.pack();
        this.jta_in.requestFocus();
    }

    private void loadFromFile() {
        File f = this.ui.getOpenFile(FileChooserType.OPEN_TEST_SCRIPT, this.me);
        if (f != null) {
            try {
                String content = FileUtil.getContentAsString(f, Charsets.UTF_8);
                Dimension d = this.jsp_in.getPreferredSize();
                this.jta_in.setText(content);
                this.jta_in.setCaretPosition(0);
                this.jsp_in.setPreferredSize(d);
            }
            catch (IOException ex) {
                this.ui.getView().showError(Util.getStackTrace(ex));
            }
        }
    }

    private void add() {
        String str = this.jta_in.getText();
        if ("".equals(str.trim())) {
            JOptionPane.showMessageDialog(this.me, "Please enter input text!", "No Input", 0);
            return;
        }
        String[] line_arr = str.split("\\n");
        ArrayList<String> linesNotMatching = new ArrayList<String>();
        LinkedHashMap<String, String> keyValMap = new LinkedHashMap<String, String>();
        for (String line : line_arr) {
            int index = line.indexOf(58);
            if (index > -1 && index != 0 && index != line.length() - 1) {
                String key = line.substring(0, index);
                String value = line.substring(index + 1);
                key = key.trim();
                value = value.trim();
                if ("".equals(key) || "".equals(value)) {
                    linesNotMatching.add(line);
                    continue;
                }
                keyValMap.put(key, value);
                continue;
            }
            if ("".equals(line.trim())) continue;
            linesNotMatching.add(line);
        }
        this.me.setVisible(false);
        this.callback.add(keyValMap, linesNotMatching);
    }

    @Override
    public void setVisible(boolean boo) {
        super.setVisible(boo);
        if (boo) {
            this.jta_in.requestFocus();
        }
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.me.setVisible(false);
    }
}

