/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;
import org.wiztools.commons.FileUtil;
import org.wiztools.restclient.FileType;
import org.wiztools.restclient.MessageI18N;
import org.wiztools.restclient.XMLException;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.server.TraceServer;
import org.wiztools.restclient.ui.AboutDialog;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.FileOpenUtil;
import org.wiztools.restclient.ui.PasswordGenDialog;
import org.wiztools.restclient.ui.RCFileFilter;
import org.wiztools.restclient.ui.RCFileView;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTViewImpl;
import org.wiztools.restclient.ui.RecentFilesHelper;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.URLEncodeDecodeDialog;
import org.wiztools.restclient.ui.history.HistoryManager;
import org.wiztools.restclient.ui.option.OptionsDialog;
import org.wiztools.restclient.util.Util;
import org.wiztools.restclient.util.XMLUtil;

@Singleton
class RESTMain
implements RESTUserInterface {
    private static final Logger LOG = Logger.getLogger(RESTMain.class.getName());
    private final Application application = new DefaultApplication();
    @Inject
    private RESTViewImpl view;
    @Inject
    private AboutDialog aboutDialog;
    @Inject
    private OptionsDialog optionsDialog;
    @Inject
    private PasswordGenDialog passwordGenDialog;
    @Inject
    private HistoryManager historyManager;
    private URLEncodeDecodeDialog urlEncodeDecodeDialog;
    private JFileChooser jfc_request = UIUtil.getNewJFileChooser();
    private JFileChooser jfc_response = UIUtil.getNewJFileChooser();
    private JFileChooser jfc_generic = UIUtil.getNewJFileChooser();
    private JFileChooser jfc_archive = UIUtil.getNewJFileChooser();
    private JFileChooser jfc_history = UIUtil.getNewJFileChooser();
    @Inject
    private RecentFilesHelper recentFilesHelper;
    private static final String URL_BOOK = "http://www.amazon.com/dp/B00D9IIGP6?tag=wiztooorg-20";
    private static final String URL_FB = "http://www.facebook.com/wiztools.org";
    private static final String URL_ISSUE = "http://code.google.com/p/rest-client/issues/list";
    private final JFrame frame;
    private static final String[] DO_SAVE_UI_REQUEST = new String[]{"Request", "completed Request"};
    private static final String[] DO_SAVE_UI_RESPONSE = new String[]{"Response", "received Response"};
    private static final String[] DO_SAVE_UI_ARCHIVE = new String[]{"Request/Response", "completed Request-Response"};

    public RESTMain() {
        this.application.addAboutMenuItem();
        this.application.addApplicationListener(new RCApplicationListener());
        this.application.addPreferencesMenuItem();
        this.frame = new JFrame("WizTools.org RESTClient 3.2");
        this.init();
    }

    @Override
    public RESTViewImpl getView() {
        return this.view;
    }

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    private void createMenu() {
        JMenu jm_file = new JMenu("File");
        jm_file.setMnemonic(70);
        JMenuItem jmi_open_req = new JMenuItem("Open Request", RCFileView.REQUEST_ICON);
        jmi_open_req.setMnemonic(79);
        jmi_open_req.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jmi_open_req.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RESTMain.this.jmi_open_reqAction();
            }
        });
        jm_file.add(jmi_open_req);
        JMenuItem jmi_open_res = new JMenuItem("Open Response", RCFileView.RESPONSE_ICON);
        jmi_open_res.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.jmi_open_resAction();
            }
        });
        jm_file.add(jmi_open_res);
        JMenuItem jmi_open_archive = new JMenuItem("Open Req-Res Archive", RCFileView.ARCHIVE_ICON);
        jmi_open_archive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.jmi_open_archiveAction();
            }
        });
        jm_file.add(jmi_open_archive);
        final JMenu jm_open_recent = new JMenu("Open recent");
        jm_open_recent.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent me) {
                List<File> recentFiles = RESTMain.this.recentFilesHelper.getRecentFiles();
                jm_open_recent.removeAll();
                for (final File f : recentFiles) {
                    JMenuItem jmi = new JMenuItem(f.getName());
                    jmi.setToolTipText(f.getAbsolutePath());
                    jmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            FileOpenUtil.open(RESTMain.this.view, f);
                        }
                    });
                    jm_open_recent.add(jmi);
                }
                if (!RESTMain.this.recentFilesHelper.isEmpty()) {
                    jm_open_recent.addSeparator();
                    JMenuItem jmi = new JMenuItem("Clear");
                    jmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            RESTMain.this.recentFilesHelper.clear();
                        }
                    });
                    jm_open_recent.add(jmi);
                }
            }

            @Override
            public void menuDeselected(MenuEvent me) {
            }

            @Override
            public void menuCanceled(MenuEvent me) {
            }
        });
        jm_file.add(jm_open_recent);
        jm_file.addSeparator();
        JMenuItem jmi_save_req = new JMenuItem("Save Request", RCFileView.REQUEST_ICON);
        jmi_save_req.setMnemonic(81);
        jmi_save_req.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jmi_save_req.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RESTMain.this.actionSave(FileChooserType.SAVE_REQUEST);
            }
        });
        jm_file.add(jmi_save_req);
        JMenuItem jmi_save_res = new JMenuItem("Save Response", RCFileView.RESPONSE_ICON);
        jmi_save_res.setMnemonic(83);
        jmi_save_res.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RESTMain.this.actionSave(FileChooserType.SAVE_RESPONSE);
            }
        });
        jm_file.add(jmi_save_res);
        JMenuItem jmi_save_res_body = new JMenuItem("Save Response Body", RCFileView.FILE_ICON);
        jmi_save_res_body.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.actionSave(FileChooserType.SAVE_RESPONSE_BODY);
            }
        });
        jm_file.add(jmi_save_res_body);
        JMenuItem jmi_save_archive = new JMenuItem("Save Req-Res Archive", RCFileView.ARCHIVE_ICON);
        jmi_save_archive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.actionSave(FileChooserType.SAVE_ARCHIVE);
            }
        });
        jm_file.add(jmi_save_archive);
        if (!this.application.isMac()) {
            jm_file.addSeparator();
            JMenuItem jmi_exit = new JMenuItem("Exit", UIUtil.getIconFromClasspath("org/wiztools/restclient/fv_exit.png"));
            jmi_exit.setMnemonic(88);
            jmi_exit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jmi_exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RESTMain.this.shutdownCall();
                }
            });
            jm_file.add(jmi_exit);
        }
        JMenu jm_edit = new JMenu("Edit");
        jm_edit.setMnemonic(69);
        JMenuItem jmi_clear_res = new JMenuItem("Clear Response");
        jmi_clear_res.setMnemonic(67);
        jmi_clear_res.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.view.clearUIResponse();
            }
        });
        jm_edit.add(jmi_clear_res);
        JMenuItem jmi_reset_all = new JMenuItem("Reset All");
        jmi_reset_all.setMnemonic('a');
        jmi_reset_all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.view.clearUIResponse();
                RESTMain.this.view.clearUIRequest();
            }
        });
        jm_edit.add(jmi_reset_all);
        jm_edit.addSeparator();
        JMenuItem jmi_reset_to_last = new JMenuItem("Reset to Last Request-Response");
        jmi_reset_to_last.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RESTMain.this.view.getLastRequest() != null && RESTMain.this.view.getLastResponse() != null) {
                    RESTMain.this.view.setUIToLastRequestResponse();
                } else {
                    JOptionPane.showMessageDialog(RESTMain.this.frame, "No Last Request-Response Available", "No Last Request-Response Available", 1);
                }
            }
        });
        jm_edit.add(jmi_reset_to_last);
        JMenu jm_history = new JMenu("History");
        final JMenuItem jmi_back = new JMenuItem("Back");
        jmi_back.setAccelerator(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jmi_back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block7: {
                    if (RESTMain.this.historyManager.isMostRecent()) {
                        try {
                            Request reqFromUi = RESTMain.this.view.getRequestFromUI();
                            if (!reqFromUi.equals(RESTMain.this.historyManager.current())) {
                                RESTMain.this.view.setUIFromRequest(RESTMain.this.historyManager.current());
                                return;
                            }
                        }
                        catch (IllegalStateException ex) {
                            if (RESTMain.this.historyManager.current() == null) break block7;
                            RESTMain.this.view.setUIFromRequest(RESTMain.this.historyManager.current());
                            return;
                        }
                    }
                }
                if (!RESTMain.this.historyManager.isOldest()) {
                    Request request = RESTMain.this.historyManager.back();
                    if (request != null) {
                        RESTMain.this.view.setUIFromRequest(request);
                    }
                } else {
                    RESTMain.this.view.setStatusMessage("Already in oldest");
                }
            }
        });
        jm_history.add(jmi_back);
        final JMenuItem jmi_forward = new JMenuItem("Forward");
        jmi_forward.setAccelerator(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jmi_forward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RESTMain.this.historyManager.isMostRecent()) {
                    Request request = RESTMain.this.historyManager.forward();
                    if (request != null) {
                        RESTMain.this.view.setUIFromRequest(request);
                    }
                } else {
                    RESTMain.this.view.setStatusMessage("Already in latest");
                }
            }
        });
        jm_history.add(jmi_forward);
        jm_history.addSeparator();
        JMenuItem jmi_clear_history = new JMenuItem("Clear History");
        jmi_clear_history.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.historyManager.clear();
                RESTMain.this.view.setStatusMessage("History cleared");
            }
        });
        jm_history.add(jmi_clear_history);
        jm_history.addSeparator();
        JMenuItem jmi_save_history = new JMenuItem("Save History");
        jmi_save_history.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RESTMain.this.historyManager.isEmpty()) {
                    JOptionPane.showMessageDialog(RESTMain.this.frame, "History is empty!");
                    return;
                }
                File f = FileType.getWithExtension(RESTMain.this.getSaveFile(FileChooserType.SAVE_HISTORY), FileType.HISTORY);
                if (f != null) {
                    try {
                        RESTMain.this.historyManager.save(f);
                        RESTMain.this.view.setStatusMessage("Saved history file: " + f.getName());
                    }
                    catch (IOException ex) {
                        RESTMain.this.view.showError(Util.getStackTrace(ex));
                    }
                }
            }
        });
        jm_history.add(jmi_save_history);
        JMenuItem jmi_load_history = new JMenuItem("Load History");
        jmi_load_history.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int confirm;
                if (!(RESTMain.this.historyManager.isEmpty() || (confirm = JOptionPane.showConfirmDialog(null, "Overwrite existing history?", "Existing history will be overwritten. Proceed?", 0)) != 1 && confirm != -1)) {
                    return;
                }
                File f = RESTMain.this.getOpenFile(FileChooserType.OPEN_HISTORY);
                if (f != null) {
                    try {
                        RESTMain.this.historyManager.clear();
                        RESTMain.this.historyManager.load(f);
                    }
                    catch (IOException ex) {
                        RESTMain.this.view.showError(Util.getStackTrace(ex));
                    }
                }
            }
        });
        jm_history.add(jmi_load_history);
        jm_history.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (RESTMain.this.historyManager.isOldest()) {
                    jmi_back.setEnabled(false);
                } else {
                    jmi_back.setEnabled(true);
                }
                if (RESTMain.this.historyManager.isMostRecent()) {
                    jmi_forward.setEnabled(false);
                } else {
                    jmi_forward.setEnabled(true);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        JMenu jm_tools = new JMenu("Tools");
        jm_tools.setMnemonic('o');
        JMenuItem jmi_url_encode = new JMenuItem("URL Encoder/Decoder");
        jmi_url_encode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RESTMain.this.urlEncodeDecodeDialog == null) {
                    RESTMain.this.urlEncodeDecodeDialog = new URLEncodeDecodeDialog(RESTMain.this.frame);
                }
                RESTMain.this.urlEncodeDecodeDialog.setVisible(true);
            }
        });
        jm_tools.add(jmi_url_encode);
        JMenuItem jmi_pwd_gen = new JMenuItem("Password Encoder/Decoder");
        jmi_pwd_gen.setMnemonic('p');
        jmi_pwd_gen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RESTMain.this.passwordGenDialog.setVisible(true);
            }
        });
        jm_tools.add(jmi_pwd_gen);
        jm_tools.addSeparator();
        JMenuItem jmi_server_start = new JMenuItem("Start Trace Server @ port " + TraceServer.PORT);
        jmi_server_start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    TraceServer.start();
                    RESTMain.this.view.setStatusMessage("Trace Server started.");
                }
                catch (Exception ex) {
                    RESTMain.this.view.showError(Util.getStackTrace(ex));
                }
            }
        });
        jm_tools.add(jmi_server_start);
        JMenuItem jmi_server_stop = new JMenuItem("Stop Trace Server");
        jmi_server_stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (TraceServer.isRunning()) {
                        TraceServer.stop();
                        RESTMain.this.view.setStatusMessage("Trace Server stopped.");
                    }
                }
                catch (Exception ex) {
                    RESTMain.this.view.showError(Util.getStackTrace(ex));
                }
            }
        });
        jm_tools.add(jmi_server_stop);
        JMenuItem jmi_server_fill_url = new JMenuItem("Insert Trace Server URL");
        jmi_server_fill_url.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int ret;
                String url = RESTMain.this.view.getUrl();
                if (url != null && (ret = JOptionPane.showConfirmDialog(RESTMain.this.frame, "URL field not empty. Overwrite?", "Request URL not empty", 0)) == 1) {
                    return;
                }
                RESTMain.this.view.setUrl("http://localhost:" + TraceServer.PORT + "/");
            }
        });
        jm_tools.add(jmi_server_fill_url);
        if (!this.application.isMac()) {
            jm_tools.addSeparator();
            JMenuItem jmi_options = new JMenuItem("Options");
            jmi_options.setMnemonic('o');
            jmi_options.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    RESTMain.this.showOptionsDialog();
                }
            });
            jm_tools.add(jmi_options);
        }
        JMenuBar jmb = new JMenuBar();
        jmb.add(jm_file);
        jmb.add(jm_edit);
        jmb.add(jm_history);
        jmb.add(jm_tools);
        JMenu jm_help = new JMenu("Help");
        jm_help.setMnemonic(72);
        JMenuItem jmi_url = new JMenuItem("RESTClient Book (Kindle)");
        jmi_url.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.openUrl(RESTMain.URL_BOOK);
            }
        });
        jm_help.add(jmi_url);
        jmi_url = new JMenuItem("Follow in Facebook");
        jmi_url.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.openUrl(RESTMain.URL_FB);
            }
        });
        jm_help.add(jmi_url);
        jmi_url = new JMenuItem("Report Issue / Request Enhancement");
        jmi_url.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RESTMain.this.openUrl(RESTMain.URL_ISSUE);
            }
        });
        jm_help.add(jmi_url);
        if (!this.application.isMac()) {
            jm_help.addSeparator();
            JMenuItem jmi_about = new JMenuItem("About");
            jmi_about.setMnemonic('a');
            jmi_about.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RESTMain.this.showAboutDialog();
                }
            });
            jm_help.add(jmi_about);
        }
        jmb.add(jm_help);
        this.frame.setJMenuBar(jmb);
    }

    private void init() {
        this.jfc_request.addChoosableFileFilter(new RCFileFilter(".rcq"));
        this.jfc_response.addChoosableFileFilter(new RCFileFilter(".rcs"));
        this.jfc_archive.addChoosableFileFilter(new RCFileFilter(".rcr"));
    }

    @PostConstruct
    public void show() {
        this.frame.setContentPane(this.view.getContainer());
        this.createMenu();
        ImageIcon icon = UIUtil.getIconFromClasspath("org/wiztools/restclient/logo_30.png");
        this.frame.setIconImage(icon.getImage());
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                RESTMain.this.shutdownCall();
            }
        });
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    private void openUrl(String url) {
        Desktop dt;
        Desktop desktop = dt = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (dt != null && dt.isSupported(Desktop.Action.BROWSE)) {
            try {
                dt.browse(new URI(url));
            }
            catch (URISyntaxException ex) {
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
                this.showUrlDialog(url);
            }
        } else {
            this.showUrlDialog(url);
        }
    }

    private void showUrlDialog(String url) {
        JOptionPane.showMessageDialog(this.frame, "Visit this URL: " + url, "Visit URL", 1);
    }

    private void showOptionsDialog() {
        this.optionsDialog.setVisible(true);
    }

    @Override
    public File getOpenFile(FileChooserType type) {
        return this.getOpenFile(type, this.frame);
    }

    @Override
    public File getOpenFile(FileChooserType type, Component parent) {
        String title = null;
        JFileChooser jfc = null;
        if (type == FileChooserType.OPEN_REQUEST) {
            jfc = this.jfc_request;
            title = "Open Request";
        } else if (type == FileChooserType.OPEN_RESPONSE) {
            jfc = this.jfc_response;
            title = "Open Response";
        } else if (type == FileChooserType.OPEN_ARCHIVE) {
            jfc = this.jfc_archive;
            title = "Open Req-Res Archive";
        } else if (type == FileChooserType.OPEN_REQUEST_BODY) {
            jfc = this.jfc_generic;
            title = "Open Request Body";
        } else if (type == FileChooserType.OPEN_HISTORY) {
            jfc = this.jfc_history;
            title = "Open History";
        } else if (type == FileChooserType.OPEN_TEST_SCRIPT) {
            jfc = this.jfc_generic;
            title = "Open Test Script";
        } else if (type == FileChooserType.OPEN_GENERIC) {
            jfc = this.jfc_generic;
            title = "Open";
        }
        jfc.setDialogTitle(title);
        int status = jfc.showOpenDialog(parent);
        if (status == 0) {
            File f = jfc.getSelectedFile();
            return f;
        }
        return null;
    }

    private void jmi_open_reqAction() {
        File f = this.getOpenFile(FileChooserType.OPEN_REQUEST);
        if (f != null) {
            FileOpenUtil.openRequest(this.view, f);
            this.recentFilesHelper.openedFile(f);
        }
    }

    private void jmi_open_resAction() {
        File f = this.getOpenFile(FileChooserType.OPEN_RESPONSE);
        if (f != null) {
            FileOpenUtil.openResponse(this.view, f);
            this.recentFilesHelper.openedFile(f);
        }
    }

    private void jmi_open_archiveAction() {
        File f = this.getOpenFile(FileChooserType.OPEN_ARCHIVE);
        if (f != null) {
            FileOpenUtil.openArchive(this.view, f);
            this.recentFilesHelper.openedFile(f);
        }
    }

    @Override
    public File getSaveFile(FileChooserType type) {
        JFileChooser jfc = null;
        String title = null;
        if (type == FileChooserType.SAVE_REQUEST) {
            jfc = this.jfc_request;
            title = "Save Request";
        } else if (type == FileChooserType.SAVE_RESPONSE) {
            jfc = this.jfc_response;
            title = "Save Response";
        } else if (type == FileChooserType.SAVE_RESPONSE_BODY) {
            jfc = this.jfc_generic;
            title = "Save Response Body";
        } else if (type == FileChooserType.SAVE_ARCHIVE) {
            jfc = this.jfc_archive;
            title = "Save Req-Res Archive";
        } else if (type == FileChooserType.SAVE_HISTORY) {
            jfc = this.jfc_history;
            title = "Save History";
        }
        jfc.setDialogTitle(title);
        int status = jfc.showSaveDialog(this.frame);
        if (status == 0) {
            File f = jfc.getSelectedFile();
            if (f == null) {
                return null;
            }
            String ext = null;
            switch (type) {
                case SAVE_REQUEST: {
                    ext = ".rcq";
                    break;
                }
                case SAVE_RESPONSE: {
                    ext = ".rcs";
                    break;
                }
                case SAVE_ARCHIVE: {
                    ext = ".rcr";
                    break;
                }
            }
            if (ext != null) {
                String path = f.getAbsolutePath();
                path = path.toLowerCase();
                FileFilter ff = jfc.getFileFilter();
                RCFileFilter rcFileFilter = null;
                if (ff instanceof RCFileFilter) {
                    rcFileFilter = (RCFileFilter)ff;
                }
                if (rcFileFilter != null && rcFileFilter.getFileTypeExt().equals(ext) && !path.endsWith(ext)) {
                    f = new File(f.getAbsolutePath() + ext);
                    jfc.setSelectedFile(f);
                    this.view.setStatusMessage("Adding default extension: " + ext);
                }
            }
            if (f.exists()) {
                int yesNo = JOptionPane.showConfirmDialog(this.frame, "File exists. Overwrite?", "File exists", 0);
                if (yesNo == 0) {
                    return f;
                }
                JOptionPane.showMessageDialog(this.frame, "File not saved!", "Not saved", 1);
            } else {
                return f;
            }
        }
        return null;
    }

    private boolean doSaveEvenIfUIChanged(String[] parameters) {
        String message = MessageI18N.getMessage("yes-no.cant.save.req-res", parameters);
        int optionChoosen = JOptionPane.showConfirmDialog(this.view.getContainer(), message, "UI Parameters Changed!", 2, 1);
        return optionChoosen == 0;
    }

    private void actionSave(FileChooserType type) {
        block33: {
            if (type == FileChooserType.SAVE_REQUEST) {
                Request request = this.view.getLastRequest();
                if (request == null) {
                    JOptionPane.showMessageDialog(this.view.getContainer(), "No last request available.", "No Request", 0);
                    return;
                }
                try {
                    Request uiRequest = this.view.getRequestFromUI();
                    if (!request.equals(uiRequest) && !this.doSaveEvenIfUIChanged(DO_SAVE_UI_REQUEST)) {
                        return;
                    }
                    File f = this.getSaveFile(FileChooserType.SAVE_REQUEST);
                    if (f == null) break block33;
                    try {
                        XMLUtil.writeRequestXML(request, f);
                        this.recentFilesHelper.openedFile(f);
                    }
                    catch (IOException ex) {
                        this.view.showError(Util.getStackTrace(ex));
                    }
                    catch (XMLException ex) {
                        this.view.showError(Util.getStackTrace(ex));
                    }
                }
                catch (IllegalStateException ex) {
                    this.view.showError(Util.getStackTrace(ex));
                }
            } else if (type == FileChooserType.SAVE_RESPONSE) {
                Response response = this.view.getLastResponse();
                if (response == null) {
                    JOptionPane.showMessageDialog(this.view.getContainer(), "No last response available.", "No Response", 0);
                    return;
                }
                Response uiResponse = this.view.getResponseFromUI();
                if (!response.equals(uiResponse) && !this.doSaveEvenIfUIChanged(DO_SAVE_UI_RESPONSE)) {
                    return;
                }
                File f = this.getSaveFile(FileChooserType.SAVE_RESPONSE);
                if (f != null) {
                    try {
                        XMLUtil.writeResponseXML(response, f);
                        this.recentFilesHelper.openedFile(f);
                    }
                    catch (IOException ex) {
                        this.view.showError(Util.getStackTrace(ex));
                    }
                    catch (XMLException ex) {
                        this.view.showError(Util.getStackTrace(ex));
                    }
                }
            } else if (type == FileChooserType.SAVE_RESPONSE_BODY) {
                Response response = this.view.getLastResponse();
                if (response == null) {
                    JOptionPane.showMessageDialog(this.view.getContainer(), "No last response available.", "No Response", 0);
                    return;
                }
                if (response.getResponseBody() == null) {
                    JOptionPane.showMessageDialog(this.view.getContainer(), "Last response does not have body.", "No Body in Response", 0);
                    return;
                }
                File f = this.getSaveFile(FileChooserType.SAVE_RESPONSE_BODY);
                if (f != null) {
                    try {
                        FileUtil.writeBytes(f, response.getResponseBody());
                    }
                    catch (IOException ex) {
                        this.view.showError(Util.getStackTrace(ex));
                    }
                }
            } else if (type == FileChooserType.SAVE_ARCHIVE) {
                Request request = this.view.getLastRequest();
                Response response = this.view.getLastResponse();
                if (request == null || response == null) {
                    JOptionPane.showMessageDialog(this.view.getContainer(), "No last request/response available.", "No Request/Response", 0);
                    return;
                }
                try {
                    Request uiRequest = this.view.getRequestFromUI();
                    Response uiResponse = this.view.getResponseFromUI();
                    if (!(request.equals(uiRequest) && response.equals(uiResponse) || this.doSaveEvenIfUIChanged(DO_SAVE_UI_ARCHIVE))) {
                        return;
                    }
                    File f = this.getSaveFile(FileChooserType.SAVE_ARCHIVE);
                    if (f == null) break block33;
                    Exception e = null;
                    try {
                        Util.createReqResArchive(request, response, f);
                        this.recentFilesHelper.openedFile(f);
                    }
                    catch (IOException ex) {
                        e = ex;
                    }
                    catch (XMLException ex) {
                        e = ex;
                    }
                    if (e != null) {
                        this.view.showError(Util.getStackTrace(e));
                    }
                }
                catch (IllegalStateException ex) {
                    this.view.showError(Util.getStackTrace(ex));
                }
            }
        }
    }

    private void shutdownCall() {
        this.recentFilesHelper.store();
        System.out.println("Exiting...");
        System.exit(0);
    }

    public void showAboutDialog() {
        this.aboutDialog.setVisible(true);
    }

    public class RCApplicationListener
    implements ApplicationListener {
        @Override
        public void handleAbout(ApplicationEvent ae) {
            RESTMain.this.showAboutDialog();
            ae.setHandled(true);
        }

        @Override
        public void handleOpenApplication(ApplicationEvent ae) {
        }

        @Override
        public void handleOpenFile(ApplicationEvent ae) {
            String fileName = ae.getFilename();
            File f = new File(fileName);
            FileOpenUtil.open(RESTMain.this.view, f);
            ae.setHandled(true);
        }

        @Override
        public void handlePreferences(ApplicationEvent ae) {
            RESTMain.this.showOptionsDialog();
            ae.setHandled(true);
        }

        @Override
        public void handlePrintFile(ApplicationEvent ae) {
            JOptionPane.showMessageDialog(RESTMain.this.frame, "Sorry, printing not implemented");
        }

        @Override
        public void handleQuit(ApplicationEvent ae) {
            RESTMain.this.shutdownCall();
        }

        @Override
        public void handleReOpenApplication(ApplicationEvent ae) {
            RESTMain.this.frame.setVisible(true);
            ae.setHandled(true);
        }
    }
}

