/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.wiztools.restclient.ui.ScriptEditor;
import org.wiztools.restclient.ui.TextEditorSyntax;

public class RSyntaxScriptEditor
implements ScriptEditor {
    private final RSyntaxTextArea textArea = new RSyntaxTextArea();

    public RSyntaxScriptEditor() {
        this.textArea.setPopupMenu(null);
        this.textArea.setAntiAliasingEnabled(true);
    }

    public RSyntaxScriptEditor(TextEditorSyntax syntax) {
        this();
        this.setSyntax(syntax);
    }

    @Override
    public final void setSyntax(TextEditorSyntax syntax) {
        if (syntax == TextEditorSyntax.GROOVY) {
            this.textArea.setSyntaxEditingStyle("text/groovy");
        } else if (syntax == TextEditorSyntax.XML) {
            this.textArea.setSyntaxEditingStyle("text/xml");
        } else if (syntax == TextEditorSyntax.JSON) {
            this.textArea.setSyntaxEditingStyle("text/javascript");
        } else {
            this.textArea.setSyntaxEditingStyle("text/plain");
        }
    }

    @Override
    public JComponent getEditorView() {
        return this.textArea;
    }

    @Override
    public JTextComponent getEditorComponent() {
        return this.textArea;
    }

    @Override
    public String getText() {
        return this.textArea.getText();
    }

    @Override
    public void setText(String text) {
        this.textArea.setText(text);
    }

    @Override
    public void setCaretPosition(int offset) {
        this.textArea.setCaretPosition(offset);
    }

    @Override
    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textArea.setEnabled(enabled);
    }

    @Override
    public void setPopupMenu(JPopupMenu menu) {
        this.textArea.setPopupMenu(menu);
    }
}

