/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.util.Collections;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.ui.ISessionView;

class SessionTableModel
extends AbstractTableModel
implements ISessionView {
    private final String[] colNames;
    private Object[][] data = new String[0][0];

    public SessionTableModel(String[] colNames) {
        if (colNames.length != 2) {
            throw new IllegalArgumentException("The length of array should be equal to 2.");
        }
        this.colNames = colNames;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public String getColumnName(int col) {
        return this.colNames[col];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public void insertRow(Object key, Object value) {
        int len = this.data.length;
        Object[][] t = new Object[len + 1][2];
        t[0][0] = key;
        t[0][1] = value;
        for (int i = 1; i < len + 1; ++i) {
            for (int j = 0; j < 2; ++j) {
                t[i][j] = this.data[i - 1][j];
            }
        }
        this.data = null;
        this.data = t;
        this.fireTableDataChanged();
    }

    public void setData(Map<String, String> dataMap) {
        int size = dataMap.size();
        Object[] keys = dataMap.keySet().toArray();
        Object[][] o = new Object[size][2];
        for (int i = 0; i < size; ++i) {
            o[i][0] = keys[i];
            o[i][1] = dataMap.get(keys[i]);
        }
        this.data = null;
        this.data = o;
        this.fireTableDataChanged();
    }

    public Object[][] getData() {
        return this.data;
    }

    @Override
    public void add(Request request, Response response) {
        this.insertRow(request.toString(), response.toString());
    }

    @Override
    public void clear() {
        this.setData(Collections.EMPTY_MAP);
    }
}

