/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.StatusBarPanel;
import org.wiztools.restclient.ui.UIUtil;

public class StatusBarPanelImpl
extends JPanel
implements StatusBarPanel {
    @Inject
    private RESTView view;
    private JLabel jl_status = new JLabel(" WizTools.org RESTClient ");
    private JProgressBar jpb_status = new JProgressBar();
    private Calendar statusLastUpdated;

    @PostConstruct
    protected void init() {
        this.statusLastUpdated = Calendar.getInstance();
        new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar c = (Calendar)StatusBarPanelImpl.this.statusLastUpdated.clone();
                c.add(13, 20);
                if (Calendar.getInstance().after(c)) {
                    StatusBarPanelImpl.this.setStatus("WizTools.org RESTClient ");
                }
            }
        }).start();
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setLayout(new GridLayout(1, 2));
        this.jl_status.setFont(UIUtil.FONT_DIALOG_12_PLAIN);
        this.add(this.jl_status);
        JPanel jp_progressBar = new JPanel();
        jp_progressBar.setLayout(new FlowLayout(2));
        Dimension d = this.jpb_status.getPreferredSize();
        d.height -= 2;
        this.jpb_status.setPreferredSize(d);
        this.jpb_status.setIndeterminate(true);
        this.jpb_status.setVisible(false);
        jp_progressBar.add(this.jpb_status);
        this.add(jp_progressBar);
    }

    @Override
    public void setStatus(String status) {
        this.jl_status.setText(" " + status);
        this.jl_status.setToolTipText(status);
        this.statusLastUpdated = Calendar.getInstance();
    }

    @Override
    public void showProgressBar() {
        this.jpb_status.setVisible(true);
    }

    @Override
    public void hideProgressBar() {
        this.jpb_status.setVisible(false);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void clear() {
        this.setStatus("Cleared!");
    }
}

