/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.history;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.ui.history.HistoryManager;
import org.wiztools.restclient.ui.lifecycle.LifecycleManager;
import org.wiztools.restclient.ui.lifecycle.Shutdown;
import org.wiztools.restclient.util.XMLCollectionUtil;

@Singleton
public class HistoryManagerImpl
implements HistoryManager {
    private int maxSize = 30;
    private int cursor;
    private LinkedList<Request> data = new LinkedList();
    @Inject
    private LifecycleManager lifecycle;

    @PostConstruct
    protected void init() {
        if (DEFAULT_FILE.exists()) {
            try {
                this.load(DEFAULT_FILE);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        this.lifecycle.registerShutdownListener(new Shutdown(){

            @Override
            public void onShutdown() {
                try {
                    HistoryManagerImpl.this.save(HistoryManager.DEFAULT_FILE);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        });
    }

    @Override
    public int getHistorySize() {
        return this.maxSize;
    }

    @Override
    public void setHistorySize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("History max size value invalid: " + size);
        }
        if (this.maxSize == size) {
            return;
        }
        if (this.maxSize > size) {
            if (this.cursor >= size) {
                this.cursor = size - 1;
            }
            if (this.data.size() > size) {
                int diff = this.data.size() - size;
                for (int i = 0; i < diff; ++i) {
                    this.data.removeLast();
                }
            }
        }
        this.maxSize = size;
    }

    @Override
    public void add(Request request) {
        if (this.cursor != 0) {
            for (int i = 0; i < this.cursor; ++i) {
                this.data.removeFirst();
            }
        }
        this.data.addFirst(request);
        if (this.data.size() > this.maxSize) {
            this.data.removeLast();
        }
        this.cursor = 0;
    }

    @Override
    public boolean isOldest() {
        if (this.data.isEmpty()) {
            return true;
        }
        return this.cursor == this.data.size() - 1;
    }

    @Override
    public boolean isMostRecent() {
        return this.cursor == 0;
    }

    @Override
    public Request back() {
        if (this.isOldest()) {
            return null;
        }
        return this.data.get(++this.cursor);
    }

    @Override
    public Request forward() {
        if (this.isMostRecent()) {
            return null;
        }
        return this.data.get(--this.cursor);
    }

    @Override
    public Request current() {
        if (this.data.isEmpty()) {
            return null;
        }
        return this.data.get(this.cursor);
    }

    @Override
    public Request lastRequest() {
        if (this.data.isEmpty()) {
            return null;
        }
        return this.data.getFirst();
    }

    @Override
    public void clear() {
        this.data.clear();
        this.cursor = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int size() {
        return this.data.size();
    }

    public int cursor() {
        return this.cursor;
    }

    @Override
    public void save(File file) throws IOException {
        XMLCollectionUtil.writeRequestCollectionXML(this.data, file);
    }

    @Override
    public void load(File file) throws IOException {
        if (!this.data.isEmpty()) {
            throw new IllegalStateException("History is already initialized. Cannot initialize now.");
        }
        List<Request> requests = XMLCollectionUtil.getRequestCollectionFromXMLFile(file);
        this.data.addAll(requests);
    }

    public String toString() {
        return "HistoryManagerImpl{maxCount=" + this.maxSize + ", cursor=" + this.cursor + ", data=" + this.data + '}';
    }
}

