/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.lifecycle;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.wiztools.restclient.ui.lifecycle.LifecycleManager;
import org.wiztools.restclient.ui.lifecycle.Shutdown;
import org.wiztools.restclient.ui.lifecycle.Startup;

@Singleton
public class LifecycleManagerImpl
implements LifecycleManager {
    private final List<Startup> startupListeners = new ArrayList<Startup>();
    private final List<Shutdown> shutdownListeners = new ArrayList<Shutdown>();

    @PostConstruct
    protected void init() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (Shutdown s : LifecycleManagerImpl.this.shutdownListeners) {
                    s.onShutdown();
                }
            }
        });
    }

    @Override
    public void registerStartupListener(Startup startupListener) {
        this.startupListeners.add(startupListener);
    }

    @Override
    public void registerShutdownListener(Shutdown shutdownListener) {
        this.shutdownListeners.add(shutdownListener);
    }

    @Override
    public void runStartupListeners() {
        for (Startup s : this.startupListeners) {
            s.onStartup();
        }
    }
}

