/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.ui.option.IOptionsPanel;

public class OptionsConnectionPanel
extends JPanel
implements IOptionsPanel {
    private static final Logger LOG = Logger.getLogger(OptionsConnectionPanel.class.getName());
    private static final String PROP_PREFIX = "conn.options.";
    private static final String MINUTES = "Minutes";
    private static final String SECONDS = "Seconds";
    private static final String MILLISECONDS = "Milli-seconds";
    private JRadioButton jrb_minutes = new JRadioButton("Minutes");
    private JRadioButton jrb_seconds = new JRadioButton("Seconds");
    private JRadioButton jrb_millisecs = new JRadioButton("Milli-seconds");
    private JFormattedTextField jftf_timeout = new JFormattedTextField((Object)Integer.parseInt(ServiceLocator.getInstance(IGlobalOptions.class).getProperty("request-timeout-in-millis")));
    private String lastSelected;
    private String ok_type = "Milli-seconds";
    private Integer ok_value = Integer.parseInt(ServiceLocator.getInstance(IGlobalOptions.class).getProperty("request-timeout-in-millis"));

    public OptionsConnectionPanel() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jrb_minutes);
        bg.add(this.jrb_seconds);
        bg.add(this.jrb_millisecs);
        this.jrb_millisecs.setSelected(true);
        this.lastSelected = MILLISECONDS;
        ConvertListener al = new ConvertListener();
        this.jrb_minutes.addActionListener(al);
        this.jrb_seconds.addActionListener(al);
        this.jrb_millisecs.addActionListener(al);
        JPanel jp_radio = new JPanel();
        jp_radio.setLayout(new FlowLayout(0));
        jp_radio.add(this.jrb_minutes);
        jp_radio.add(this.jrb_seconds);
        jp_radio.add(this.jrb_millisecs);
        JPanel jp_timeout = new JPanel();
        jp_timeout.setLayout(new FlowLayout(0));
        this.jftf_timeout.setColumns(20);
        jp_timeout.add(this.jftf_timeout);
        JPanel jp_label_grid = new JPanel();
        jp_label_grid.setLayout(new GridLayout(2, 1));
        jp_label_grid.add(new JLabel("Timeout in: "));
        jp_label_grid.add(new JLabel("Value: "));
        JPanel jp_input_grid = new JPanel();
        jp_input_grid.setLayout(new GridLayout(2, 1));
        jp_input_grid.add(jp_radio);
        jp_input_grid.add(jp_timeout);
        OptionsConnectionPanel jp_encp = this;
        jp_encp.setLayout(new BorderLayout());
        jp_encp.add((Component)jp_label_grid, "West");
        jp_encp.add((Component)jp_input_grid, "Center");
        jp_encp.setBorder(BorderFactory.createTitledBorder("Request Timeout"));
    }

    int getTimeoutInMillis() {
        int value = (Integer)this.jftf_timeout.getValue();
        if (this.jrb_seconds.isSelected()) {
            return value * 1000;
        }
        if (this.jrb_minutes.isSelected()) {
            return value * 60 * 1000;
        }
        return value;
    }

    @Override
    public List<String> validateInput() {
        return null;
    }

    @Override
    public boolean saveOptions() {
        int reqTimeout = (Integer)this.jftf_timeout.getValue();
        this.ok_type = MILLISECONDS;
        if (this.jrb_minutes.isSelected()) {
            reqTimeout = 60000 * reqTimeout;
            this.ok_type = MINUTES;
        } else if (this.jrb_seconds.isSelected()) {
            reqTimeout = 1000 * reqTimeout;
            this.ok_type = SECONDS;
        }
        this.ok_value = reqTimeout;
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        options.acquire();
        options.setProperty("request-timeout-in-millis", String.valueOf(reqTimeout));
        options.release();
        return true;
    }

    private void setUIFromCache() {
        if (this.ok_type.equals(MILLISECONDS)) {
            this.jrb_millisecs.setSelected(true);
        } else if (this.ok_type.equals(SECONDS)) {
            this.jrb_seconds.setSelected(true);
        } else if (this.ok_type.equals(MINUTES)) {
            this.jrb_minutes.setSelected(true);
        }
        this.jftf_timeout.setValue(this.ok_value);
    }

    @Override
    public boolean revertOptions() {
        this.setUIFromCache();
        return true;
    }

    @Override
    public void initOptions() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        try {
            String t = options.getProperty("conn.options.type");
            this.ok_type = t == null ? this.ok_type : t;
            this.ok_value = Integer.parseInt(options.getProperty("conn.options.value"));
            if (SECONDS.equals(this.ok_type)) {
                this.lastSelected = SECONDS;
                this.ok_value = this.ok_value / 1000;
            } else if (MINUTES.equals(this.ok_type)) {
                this.lastSelected = MINUTES;
                this.ok_value = this.ok_value / 1000 / 60;
            }
            this.setUIFromCache();
        }
        catch (Exception ex) {
            LOG.info("Could not load Connection options from property.");
        }
    }

    @Override
    public void shutdownOptions() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        options.setProperty("conn.options.type", this.ok_type);
        options.setProperty("conn.options.value", String.valueOf(this.ok_value));
    }

    class ConvertListener
    implements ActionListener {
        ConvertListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OptionsConnectionPanel.this.jrb_millisecs.isSelected()) {
                if (OptionsConnectionPanel.this.lastSelected.equals(OptionsConnectionPanel.MILLISECONDS)) {
                    return;
                }
                if (OptionsConnectionPanel.this.lastSelected.equals(OptionsConnectionPanel.SECONDS)) {
                    int valueInSecs = (Integer)OptionsConnectionPanel.this.jftf_timeout.getValue();
                    int valueInMillis = valueInSecs * 1000;
                    OptionsConnectionPanel.this.jftf_timeout.setValue(valueInMillis);
                } else if (OptionsConnectionPanel.this.lastSelected.equals(OptionsConnectionPanel.MINUTES)) {
                    int valueInMins = (Integer)OptionsConnectionPanel.this.jftf_timeout.getValue();
                    int valueInMillis = valueInMins * 60 * 1000;
                    OptionsConnectionPanel.this.jftf_timeout.setValue(valueInMillis);
                }
                OptionsConnectionPanel.this.lastSelected = OptionsConnectionPanel.MILLISECONDS;
            } else if (OptionsConnectionPanel.this.jrb_seconds.isSelected()) {
                if (OptionsConnectionPanel.this.lastSelected.equals(OptionsConnectionPanel.MILLISECONDS)) {
                    int valueInMillis = (Integer)OptionsConnectionPanel.this.jftf_timeout.getValue();
                    int valueInSecs = valueInMillis / 1000;
                    OptionsConnectionPanel.this.jftf_timeout.setValue(valueInSecs);
                } else {
                    if (OptionsConnectionPanel.this.lastSelected.equals(OptionsConnectionPanel.SECONDS)) {
                        return;
                    }
                    if (OptionsConnectionPanel.this.lastSelected.equals(OptionsConnectionPanel.MINUTES)) {
                        int valueInMins = (Integer)OptionsConnectionPanel.this.jftf_timeout.getValue();
                        int valueInSecs = valueInMins * 60;
                        OptionsConnectionPanel.this.jftf_timeout.setValue(valueInSecs);
                    }
                }
                OptionsConnectionPanel.this.lastSelected = OptionsConnectionPanel.SECONDS;
            } else if (OptionsConnectionPanel.this.jrb_minutes.isSelected()) {
                if (OptionsConnectionPanel.this.lastSelected.equals(OptionsConnectionPanel.MILLISECONDS)) {
                    int valueInMillis = (Integer)OptionsConnectionPanel.this.jftf_timeout.getValue();
                    int valueInMins = valueInMillis / 60000;
                    OptionsConnectionPanel.this.jftf_timeout.setValue(valueInMins);
                } else if (OptionsConnectionPanel.this.lastSelected.equals(OptionsConnectionPanel.SECONDS)) {
                    int valueInSecs = (Integer)OptionsConnectionPanel.this.jftf_timeout.getValue();
                    int valueInMins = valueInSecs / 60;
                    OptionsConnectionPanel.this.jftf_timeout.setValue(valueInMins);
                } else if (OptionsConnectionPanel.this.lastSelected.equals(OptionsConnectionPanel.MINUTES)) {
                    return;
                }
                OptionsConnectionPanel.this.lastSelected = OptionsConnectionPanel.MINUTES;
            }
        }
    }
}

