/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.option;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.ui.option.IOptionsPanel;

public class OptionsEtcPanel
extends JPanel
implements IOptionsPanel {
    private static final Logger LOG = Logger.getLogger(OptionsEtcPanel.class.getName());
    private static final String INDENT_KEY = "response.body.indent";
    private static final String SYNTAX_COLOR_RESPONSE = "response.body.syntax.color";
    private static final String SYNTAX_COLOR_REQUEST = "request.body.syntax.color";
    private JCheckBox jcb_indentResponse = new JCheckBox("Auto-indent Response Body");
    private JCheckBox jcb_syntaxResponse = new JCheckBox("Default enable Response Body syntax coloring?");
    private JCheckBox jcb_syntaxRequest = new JCheckBox("Default enable Request Body syntax coloring?");

    OptionsEtcPanel() {
        this.setLayout(new FlowLayout(0));
        this.jcb_indentResponse.setMnemonic('a');
        this.jcb_syntaxRequest.setToolTipText("Requires RESTClient restart!");
        this.jcb_syntaxResponse.setToolTipText("Requires RESTClient restart!");
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(3, 1));
        jp.add(this.jcb_indentResponse);
        jp.add(this.jcb_syntaxRequest);
        jp.add(this.jcb_syntaxResponse);
        this.add(jp);
    }

    private boolean isIndentSetInGlobalOptions() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        String indentStr = options.getProperty(INDENT_KEY);
        return indentStr == null ? false : indentStr.equals("true");
    }

    private boolean isResponseSyntaxSetInGlobalOptions() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        String syntaxResponse = options.getProperty(SYNTAX_COLOR_RESPONSE);
        return syntaxResponse == null ? true : Boolean.valueOf(syntaxResponse);
    }

    private boolean isRequestSyntaxSetInGlobalOptions() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        String syntaxRequest = options.getProperty(SYNTAX_COLOR_REQUEST);
        return syntaxRequest == null ? true : Boolean.valueOf(syntaxRequest);
    }

    @Override
    public void initOptions() {
        if (this.isIndentSetInGlobalOptions()) {
            this.jcb_indentResponse.setSelected(true);
        } else {
            this.jcb_indentResponse.setSelected(false);
        }
        if (this.isResponseSyntaxSetInGlobalOptions()) {
            this.jcb_syntaxResponse.setSelected(true);
        } else {
            this.jcb_syntaxResponse.setSelected(false);
        }
        if (this.isRequestSyntaxSetInGlobalOptions()) {
            this.jcb_syntaxRequest.setSelected(true);
        } else {
            this.jcb_syntaxRequest.setSelected(false);
        }
    }

    @Override
    public void shutdownOptions() {
    }

    @Override
    public List<String> validateInput() {
        return null;
    }

    @Override
    public boolean saveOptions() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        options.setProperty(INDENT_KEY, String.valueOf(this.jcb_indentResponse.isSelected()));
        options.setProperty(SYNTAX_COLOR_REQUEST, String.valueOf(this.jcb_syntaxRequest.isSelected()));
        options.setProperty(SYNTAX_COLOR_RESPONSE, String.valueOf(this.jcb_syntaxResponse.isSelected()));
        return true;
    }

    @Override
    public boolean revertOptions() {
        this.initOptions();
        return true;
    }
}

