/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.option;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.ui.RESTViewImpl;
import org.wiztools.restclient.ui.option.IOptionsPanel;

public class OptionsFontPanel
extends JPanel
implements IOptionsPanel {
    private static final Logger LOG = Logger.getLogger(OptionsFontPanel.class.getName());
    private static final String PROP_PREFIX = "font.options.";
    private JButton jb_default = new JButton("Restore Default");
    private JList jl_font;
    private JList jl_fontSize;
    private JLabel jl_preview = new JLabel("WizTools.org RESTClient");

    public OptionsFontPanel() {
        OptionsFontPanel jp = this;
        jp.setLayout(new BorderLayout());
        JPanel jp_north = new JPanel();
        jp_north.setLayout(new FlowLayout(0));
        JLabel jl = new JLabel("Font for Request Body & Response Body");
        jp_north.add(jl);
        this.jb_default.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OptionsFontPanel.this.jl_font.setSelectedValue("Dialog", true);
                OptionsFontPanel.this.jl_fontSize.setSelectedValue("12", true);
            }
        });
        jp_north.add(this.jb_default);
        jp.add((Component)jp_north, "North");
        Preview previewListner = new Preview();
        int _W = 200;
        int _H = 100;
        Dimension d = new Dimension(200, 100);
        JPanel jp_center = new JPanel();
        jp_center.setLayout(new GridLayout(1, 2));
        String[] fontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.jl_font = new JList<String>(fontFamilyNames);
        this.jl_font.setSelectionMode(0);
        this.jl_font.addListSelectionListener(previewListner);
        JScrollPane jsp_font = new JScrollPane(this.jl_font);
        jsp_font.setPreferredSize(d);
        jp_center.add(jsp_font);
        String[] fontSizes = new String[]{"8", "10", "11", "12", "14", "16", "18", "20", "24", "30", "36", "40", "48", "60", "72"};
        this.jl_fontSize = new JList<String>(fontSizes);
        this.jl_fontSize.setSelectionMode(0);
        this.jl_fontSize.addListSelectionListener(previewListner);
        JScrollPane jsp_fontSize = new JScrollPane(this.jl_fontSize);
        jsp_fontSize.setPreferredSize(d);
        jp_center.add(jsp_fontSize);
        jp.add((Component)jp_center, "Center");
        JPanel jp_south = new JPanel();
        jp_south.setLayout(new FlowLayout(1));
        jp_south.add(this.jl_preview);
        jp_south.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        jp_south.setPreferredSize(new Dimension(200, 50));
        jp.add((Component)jp_south, "South");
    }

    @Override
    public void initOptions() {
        Font f = null;
        String fontName = ServiceLocator.getInstance(IGlobalOptions.class).getProperty("font.options.font");
        String fontSizeStr = ServiceLocator.getInstance(IGlobalOptions.class).getProperty("font.options.fontSize");
        int fontSize = 12;
        if (fontSizeStr != null) {
            try {
                fontSize = Integer.parseInt(fontSizeStr);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (fontName == null) {
            LOG.info("Font configuration not available in configuration. Reverting to default font.");
            f = new Font("Dialog", 0, 12);
        } else {
            f = new Font(fontName, 0, fontSize);
        }
        this.jl_font.setSelectedValue(f.getFamily(), true);
        this.jl_fontSize.setSelectedValue(String.valueOf(f.getSize()), true);
        ServiceLocator.getInstance(RESTViewImpl.class).setTextAreaFont(f);
    }

    @Override
    public void shutdownOptions() {
        ServiceLocator.getInstance(IGlobalOptions.class).setProperty("font.options.font", (String)this.jl_font.getSelectedValue());
        ServiceLocator.getInstance(IGlobalOptions.class).setProperty("font.options.fontSize", (String)this.jl_fontSize.getSelectedValue());
    }

    @Override
    public List<String> validateInput() {
        return null;
    }

    @Override
    public boolean saveOptions() {
        String fontName = (String)this.jl_font.getSelectedValue();
        String fontSizeStr = (String)this.jl_fontSize.getSelectedValue();
        int fontSize = Integer.parseInt(fontSizeStr);
        Font f = new Font(fontName, 0, fontSize);
        ServiceLocator.getInstance(RESTViewImpl.class).setTextAreaFont(f);
        return true;
    }

    @Override
    public boolean revertOptions() {
        Font f = ServiceLocator.getInstance(RESTViewImpl.class).getTextAreaFont();
        this.jl_font.setSelectedValue(f.getFamily(), true);
        this.jl_fontSize.setSelectedValue(String.valueOf(f.getSize()), true);
        return true;
    }

    class Preview
    implements ListSelectionListener {
        Preview() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (OptionsFontPanel.this.jl_font.getSelectedValue() == null || OptionsFontPanel.this.jl_fontSize.getSelectedValue() == null) {
                return;
            }
            String fontName = (String)OptionsFontPanel.this.jl_font.getSelectedValue();
            int fontSize = Integer.parseInt((String)OptionsFontPanel.this.jl_fontSize.getSelectedValue());
            Font f = new Font(fontName, 0, fontSize);
            OptionsFontPanel.this.jl_preview.setFont(f);
        }
    }
}

