/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ProxyConfig;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.ui.option.IOptionsPanel;

public class OptionsProxyPanel
extends JPanel
implements IOptionsPanel {
    private static final Logger LOG = Logger.getLogger(OptionsProxyPanel.class.getName());
    private static final String PROP_PREFIX = "proxy.options.";
    private JCheckBox jcb_enable = new JCheckBox("Enable");
    private JCheckBox jcb_auth_enable = new JCheckBox("Authentication");
    private final int jtf_size = 25;
    private JTextField jtf_host = new JTextField(25);
    private JTextField jtf_port = new JTextField(25);
    private JTextField jtf_username = new JTextField(25);
    private JPasswordField jpf_password = new JPasswordField(25);

    public OptionsProxyPanel() {
        this.toggleEnable(false);
        OptionsProxyPanel jp = this;
        jp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jp.setLayout(new BorderLayout(5, 5));
        JPanel jp_north = new JPanel();
        jp_north.setLayout(new FlowLayout(0));
        this.jcb_enable.setMnemonic('e');
        this.jcb_enable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (OptionsProxyPanel.this.jcb_enable.isSelected()) {
                    OptionsProxyPanel.this.toggleEnable(true);
                } else {
                    OptionsProxyPanel.this.toggleEnable(false);
                }
            }
        });
        jp_north.add(this.jcb_enable);
        this.jcb_auth_enable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (OptionsProxyPanel.this.jcb_auth_enable.isSelected()) {
                    OptionsProxyPanel.this.toggleAuthEnable(true);
                } else {
                    OptionsProxyPanel.this.toggleAuthEnable(false);
                }
            }
        });
        jp_north.add(this.jcb_auth_enable);
        jp.add((Component)jp_north, "North");
        JPanel jp_center = new JPanel();
        jp_center.setLayout(new BorderLayout(5, 5));
        JPanel jp_center_west = new JPanel();
        jp_center_west.setLayout(new GridLayout(4, 1, 5, 5));
        jp_center_west.add(new JLabel("Host: "));
        jp_center_west.add(new JLabel("Port: "));
        jp_center_west.add(new JLabel("Username: "));
        jp_center_west.add(new JLabel("Password: "));
        jp_center.add((Component)jp_center_west, "West");
        JPanel jp_center_center = new JPanel();
        jp_center_center.setLayout(new GridLayout(4, 1, 5, 5));
        jp_center_center.add(this.jtf_host);
        this.jtf_port.setText("8080");
        jp_center_center.add(this.jtf_port);
        jp_center_center.add(this.jtf_username);
        jp_center_center.add(this.jpf_password);
        jp_center.add((Component)jp_center_center, "Center");
        jp.add((Component)jp_center, "Center");
    }

    private void toggleEnable(boolean boo) {
        this.jtf_host.setEnabled(boo);
        this.jtf_port.setEnabled(boo);
        this.jcb_auth_enable.setEnabled(boo);
        if (!boo) {
            this.toggleAuthEnable(false);
        } else if (boo && this.jcb_auth_enable.isSelected()) {
            this.toggleAuthEnable(true);
        }
    }

    private void toggleAuthEnable(boolean boo) {
        this.jtf_username.setEnabled(boo);
        this.jpf_password.setEnabled(boo);
    }

    @Override
    public List<String> validateInput() {
        ArrayList<String> errors = new ArrayList<String>();
        boolean enabled = this.jcb_enable.isSelected();
        if (enabled) {
            String host = this.jtf_host.getText();
            int port = -1;
            try {
                port = Integer.parseInt(this.jtf_port.getText());
                if (0 >= port || port >= 65536) {
                    throw new IllegalArgumentException("Proxy Port not in valid range.");
                }
            }
            catch (NumberFormatException ex) {
                errors.add("Proxy Port is not integer.");
            }
            catch (IllegalArgumentException ex) {
                errors.add(ex.getMessage());
            }
            boolean authEnabled = this.jcb_auth_enable.isSelected();
            String username = this.jtf_username.getText();
            char[] password = this.jpf_password.getPassword();
            if (StringUtil.isEmpty(host)) {
                errors.add("Proxy Host is empty.");
            }
            if (authEnabled) {
                if (StringUtil.isEmpty(username)) {
                    errors.add("Proxy Username is empty.");
                }
                if (password == null || password.length == 0) {
                    errors.add("Proxy Password is empty.");
                }
            }
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors;
    }

    @Override
    public boolean saveOptions() {
        boolean enabled = this.jcb_enable.isSelected();
        String host = this.jtf_host.getText();
        int port = -1;
        try {
            port = Integer.parseInt(this.jtf_port.getText());
            if (0 >= port || port >= 65536) {
                throw new IllegalArgumentException("Port not in valid range.");
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        boolean authEnabled = this.jcb_auth_enable.isSelected();
        String username = this.jtf_username.getText();
        char[] password = this.jpf_password.getPassword();
        ProxyConfig proxy = ProxyConfig.getInstance();
        proxy.acquire();
        if (enabled) {
            proxy.setEnabled(true);
            proxy.setHost(host);
            proxy.setPort(port);
            if (authEnabled) {
                proxy.setAuthEnabled(true);
                proxy.setUsername(username);
                proxy.setPassword(password);
            }
        } else {
            proxy.setEnabled(false);
        }
        proxy.release();
        return true;
    }

    private void setUIFromCache() {
        ProxyConfig proxy = ProxyConfig.getInstance();
        proxy.acquire();
        this.jcb_enable.setSelected(proxy.isEnabled());
        this.jtf_host.setText(proxy.getHost());
        this.jtf_port.setText("" + proxy.getPort());
        this.jcb_auth_enable.setSelected(proxy.isAuthEnabled());
        this.jtf_username.setText(proxy.getUsername());
        if (proxy.getPassword() == null) {
            this.jpf_password.setText("");
        } else {
            this.jpf_password.setText(new String(proxy.getPassword()));
        }
        proxy.release();
        this.toggleEnable(proxy.isEnabled());
    }

    @Override
    public boolean revertOptions() {
        this.setUIFromCache();
        return true;
    }

    @Override
    public void initOptions() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        ProxyConfig proxy = ProxyConfig.getInstance();
        proxy.acquire();
        try {
            proxy.setEnabled(Boolean.valueOf(options.getProperty("proxy.options.is_enabled")));
            proxy.setHost(options.getProperty("proxy.options.host"));
            proxy.setPort(Integer.parseInt(options.getProperty("proxy.options.port")));
            proxy.setAuthEnabled(Boolean.valueOf(options.getProperty("proxy.options.is_auth_enabled")));
            proxy.setUsername(options.getProperty("proxy.options.username"));
            proxy.setPassword(options.getProperty("proxy.options.password").toCharArray());
            this.setUIFromCache();
        }
        catch (Exception ex) {
            LOG.info("Cannot load Proxy options from properties.");
        }
        proxy.release();
    }

    @Override
    public void shutdownOptions() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        ProxyConfig proxy = ProxyConfig.getInstance();
        proxy.acquire();
        options.setProperty("proxy.options.is_enabled", String.valueOf(proxy.isEnabled()));
        options.setProperty("proxy.options.host", proxy.getHost());
        options.setProperty("proxy.options.port", String.valueOf(proxy.getPort()));
        options.setProperty("proxy.options.is_auth_enabled", String.valueOf(proxy.isAuthEnabled()));
        options.setProperty("proxy.options.username", proxy.getUsername());
        String pwd = proxy.getPassword() == null ? "" : new String(proxy.getPassword());
        options.setProperty("proxy.options.password", pwd);
        proxy.release();
    }
}

