/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.Auth;
import org.wiztools.restclient.bean.BasicAuth;
import org.wiztools.restclient.bean.BasicAuthBean;
import org.wiztools.restclient.bean.BasicDigestAuth;
import org.wiztools.restclient.bean.BasicDigestAuthBaseBean;
import org.wiztools.restclient.bean.DigestAuthBean;
import org.wiztools.restclient.bean.NtlmAuth;
import org.wiztools.restclient.bean.NtlmAuthBean;
import org.wiztools.restclient.bean.OAuth2BearerAuth;
import org.wiztools.restclient.bean.OAuth2BearerAuthBean;
import org.wiztools.restclient.ui.AuthHelper;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqauth.ReqAuthPanel;

public class ReqAuthPanelImpl
extends JPanel
implements ReqAuthPanel {
    @Inject
    RESTView view;
    @Inject
    RESTUserInterface rest_ui;
    private JComboBox jcb_types = new JComboBox<String>(AuthHelper.getAll());
    private JCheckBox jcb_preemptive = new JCheckBox();
    private static final int auth_text_size = 20;
    private JTextField jtf_host = new JTextField(20);
    private JTextField jtf_realm = new JTextField(20);
    private JTextField jtf_domain = new JTextField(20);
    private JTextField jtf_workstation = new JTextField(20);
    private JTextField jtf_username = new JTextField(20);
    private JPasswordField jpf_password = new JPasswordField(20);
    private JTextField jtf_ntlm_username = new JTextField(20);
    private JPasswordField jpf_ntlm_password = new JPasswordField(20);
    private JTextField jtf_bearer_token = new JTextField(20);

    @Override
    public Auth getAuth() {
        String method = (String)this.jcb_types.getSelectedItem();
        if (AuthHelper.isBasic(method)) {
            BasicAuthBean out = new BasicAuthBean();
            this.populateBasicDigestAuth(out);
            return out;
        }
        if (AuthHelper.isDigest(method)) {
            DigestAuthBean out = new DigestAuthBean();
            this.populateBasicDigestAuth(out);
            return out;
        }
        if (AuthHelper.isNtlm(method)) {
            NtlmAuthBean out = new NtlmAuthBean();
            out.setDomain(this.jtf_domain.getText());
            out.setWorkstation(this.jtf_workstation.getText());
            out.setUsername(this.jtf_ntlm_username.getText());
            out.setPassword(this.jpf_ntlm_password.getPassword());
            return out;
        }
        if (AuthHelper.isBearer(method)) {
            OAuth2BearerAuthBean out = new OAuth2BearerAuthBean();
            out.setOAuth2BearerToken(this.jtf_bearer_token.getText());
            return out;
        }
        return null;
    }

    private void populateBasicDigestAuth(BasicDigestAuthBaseBean bean) {
        if (StringUtil.isNotEmpty(this.jtf_host.getText())) {
            bean.setHost(this.jtf_host.getText());
        }
        if (StringUtil.isNotEmpty(this.jtf_realm.getText())) {
            bean.setRealm(this.jtf_realm.getText());
        }
        if (StringUtil.isNotEmpty(this.jtf_username.getText())) {
            bean.setUsername(this.jtf_username.getText());
        }
        if (this.jpf_password.getPassword().length > 0) {
            bean.setPassword(this.jpf_password.getPassword());
        }
        bean.setPreemptive(this.jcb_preemptive.isSelected());
    }

    @Override
    public void setAuth(Auth auth) {
        if (auth instanceof BasicDigestAuth) {
            String authType = auth instanceof BasicAuth ? "BASIC" : "DIGEST";
            this.jcb_types.setSelectedItem(authType);
            BasicDigestAuth a = (BasicDigestAuth)auth;
            this.jtf_host.setText(a.getHost());
            this.jtf_realm.setText(a.getRealm());
            this.jtf_username.setText(a.getUsername());
            if (a.getPassword() != null && a.getPassword().length > 0) {
                this.jpf_password.setText(new String(a.getPassword()));
            }
            this.jcb_preemptive.setSelected(a.isPreemptive());
        } else if (auth instanceof NtlmAuth) {
            this.jcb_types.setSelectedItem("NTLM");
            NtlmAuth a = (NtlmAuth)auth;
            this.jtf_domain.setText(a.getDomain());
            this.jtf_workstation.setText(a.getWorkstation());
            this.jtf_ntlm_username.setText(a.getUsername());
            if (a.getPassword() != null && a.getPassword().length > 0) {
                this.jpf_ntlm_password.setText(new String(a.getPassword()));
            }
        } else if (auth instanceof OAuth2BearerAuth) {
            this.jcb_types.setSelectedItem("OAuth2 Bearer");
            OAuth2BearerAuth a = (OAuth2BearerAuth)auth;
            this.jtf_bearer_token.setText(a.getOAuth2BearerToken());
        }
    }

    @Override
    public void clear() {
        this.jcb_types.setSelectedItem("None");
        this.jcb_preemptive.setSelected(false);
        this.jtf_host.setText("");
        this.jtf_realm.setText("");
        this.jtf_domain.setText("");
        this.jtf_workstation.setText("");
        this.jtf_username.setText("");
        this.jpf_password.setText("");
        this.jtf_ntlm_username.setText("");
        this.jpf_ntlm_password.setText("");
        this.jtf_bearer_token.setText("");
    }

    @Override
    public List<String> validateIfFilled() {
        String method = (String)this.jcb_types.getSelectedItem();
        if (AuthHelper.isNone(method)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (AuthHelper.isBasicOrDigest(method)) {
            if (StringUtil.isEmpty(this.jtf_username.getText())) {
                errors.add("Username is empty.");
            }
            if (StringUtil.isEmpty(new String(this.jpf_password.getPassword()))) {
                errors.add("Password is empty.");
            }
        } else if (AuthHelper.isNtlm(method)) {
            if (StringUtil.isEmpty(this.jtf_domain.getText())) {
                errors.add("Domain is empty.");
            }
            if (StringUtil.isEmpty(this.jtf_workstation.getText())) {
                errors.add("Workstation is empty.");
            }
            if (StringUtil.isEmpty(this.jtf_ntlm_username.getText())) {
                errors.add("Username is empty.");
            }
            if (StringUtil.isEmpty(new String(this.jpf_ntlm_password.getPassword()))) {
                errors.add("Password is empty.");
            }
        } else if (StringUtil.isEmpty(this.jtf_bearer_token.getText())) {
            errors.add("OAuth2 Bearer Token is empty.");
        }
        return errors;
    }

    @PostConstruct
    protected void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.jcb_types, "North");
        JPanel jp_form_label = new JPanel(new GridLayout(5, 1, 5, 5));
        jp_form_label.add(new JLabel("<html>Host: </html>"));
        jp_form_label.add(new JLabel("<html>Realm: </html>"));
        jp_form_label.add(new JLabel("<html>Username: <font color=red>*</font></html>"));
        jp_form_label.add(new JLabel("<html>Password: <font color=red>*</font></html>"));
        JLabel jl_premptive = new JLabel("Preemptive?");
        String toolTipText = "Send authentication credentials before challenge";
        jl_premptive.setToolTipText(toolTipText);
        this.jcb_preemptive.setToolTipText(toolTipText);
        jl_premptive.setLabelFor(this.jcb_preemptive);
        jl_premptive.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (ReqAuthPanelImpl.this.jcb_preemptive.isSelected()) {
                    ReqAuthPanelImpl.this.jcb_preemptive.setSelected(false);
                } else {
                    ReqAuthPanelImpl.this.jcb_preemptive.setSelected(true);
                }
            }
        });
        jp_form_label.add(jl_premptive);
        JPanel jp_form_input = new JPanel(new GridLayout(5, 1, 5, 5));
        jp_form_input.add(this.jtf_host);
        jp_form_input.add(this.jtf_realm);
        jp_form_input.add(this.jtf_username);
        jp_form_input.add(this.jpf_password);
        jp_form_input.add(this.jcb_preemptive);
        JPanel jp_form = new JPanel(new BorderLayout());
        jp_form.add((Component)jp_form_label, "West");
        jp_form.add((Component)jp_form_input, "Center");
        final JPanel jp_jsp_form = UIUtil.getFlowLayoutPanelLeftAligned(jp_form);
        final JPanel jp_none = UIUtil.getFlowLayoutPanelLeftAligned(new JPanel());
        JPanel jp_oauth2_bearer = new JPanel(new FlowLayout(0));
        JLabel jl_oauth2_bearer = new JLabel("Bearer Token: ");
        jp_oauth2_bearer.add(jl_oauth2_bearer);
        jp_oauth2_bearer.add(this.jtf_bearer_token);
        final JPanel jp_jsp_oauth2_bearer = UIUtil.getFlowLayoutPanelLeftAligned(jp_oauth2_bearer);
        JPanel jp_ntlm_label = new JPanel(new GridLayout(4, 1, 5, 5));
        jp_ntlm_label.add(new JLabel("<html>Domain: <font color=red>*</font></html>"));
        jp_ntlm_label.add(new JLabel("<html>Workstation: <font color=red>*</font></html>"));
        jp_ntlm_label.add(new JLabel("<html>Username: <font color=red>*</font></html>"));
        jp_ntlm_label.add(new JLabel("<html>Password: <font color=red>*</font></html>"));
        JPanel jp_ntlm_form = new JPanel(new GridLayout(4, 1, 5, 5));
        jp_ntlm_form.add(this.jtf_domain);
        jp_ntlm_form.add(this.jtf_workstation);
        jp_ntlm_form.add(this.jtf_ntlm_username);
        jp_ntlm_form.add(this.jpf_ntlm_password);
        JButton jb_workstation_name = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/computer.png"));
        jb_workstation_name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    String localHost = InetAddress.getLocalHost().getHostName();
                    ReqAuthPanelImpl.this.jtf_workstation.setText(localHost);
                    ReqAuthPanelImpl.this.jtf_workstation.selectAll();
                    ReqAuthPanelImpl.this.jtf_workstation.requestFocus();
                }
                catch (UnknownHostException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        JPanel jp_ntlm_east = new JPanel(new GridLayout(4, 1, 5, 5));
        jp_ntlm_east.add(new JPanel());
        jp_ntlm_east.add(jb_workstation_name);
        JPanel jp_ntlm = new JPanel(new BorderLayout());
        jp_ntlm.add((Component)jp_ntlm_label, "West");
        jp_ntlm.add((Component)jp_ntlm_form, "Center");
        jp_ntlm.add((Component)jp_ntlm_east, "East");
        final JPanel jp_jsp_ntlm = UIUtil.getFlowLayoutPanelLeftAligned(jp_ntlm);
        final JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(jp_none);
        this.jcb_types.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String selected = (String)ReqAuthPanelImpl.this.jcb_types.getSelectedItem();
                if (AuthHelper.isNone(selected)) {
                    jsp.setViewportView(jp_none);
                } else if (AuthHelper.isBasicOrDigest(selected)) {
                    jsp.setViewportView(jp_jsp_form);
                    ReqAuthPanelImpl.this.jtf_host.requestFocus();
                } else if (AuthHelper.isNtlm(selected)) {
                    jsp.setViewportView(jp_jsp_ntlm);
                    ReqAuthPanelImpl.this.jtf_domain.requestFocus();
                } else if (AuthHelper.isBearer(selected)) {
                    jsp.setViewportView(jp_jsp_oauth2_bearer);
                    ReqAuthPanelImpl.this.jtf_bearer_token.requestFocus();
                }
            }
        });
        this.add((Component)jsp, "Center");
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

