/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.SSLHostnameVerifier;
import org.wiztools.restclient.bean.SSLReq;
import org.wiztools.restclient.bean.SSLReqBean;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqauth.ReqSSLPanel;

public class ReqSSLPanelImpl
extends JPanel
implements ReqSSLPanel {
    @Inject
    RESTView view;
    @Inject
    RESTUserInterface rest_ui;
    private static final int auth_text_size = 20;
    private JComboBox jcb_ssl_hostname_verifier = new JComboBox<SSLHostnameVerifier>(SSLHostnameVerifier.getAll());
    private JCheckBox jcb_ssl_trust_self_signed_cert = new JCheckBox("Trust self-signed certificate? ");
    private JTextField jtf_ssl_truststore_file = new JTextField(20);
    private JButton jb_ssl_browse = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private JPasswordField jpf_ssl_truststore_pwd = new JPasswordField(20);
    private JTextField jtf_ssl_keystore_file = new JTextField(20);
    private JButton jb_ssl_keystore_browse = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private JPasswordField jpf_ssl_keystore_pwd = new JPasswordField(20);

    @Override
    public SSLReq getSslReq() {
        SSLReqBean out = new SSLReqBean();
        out.setHostNameVerifier((SSLHostnameVerifier)((Object)this.jcb_ssl_hostname_verifier.getSelectedItem()));
        out.setTrustSelfSignedCert(this.jcb_ssl_trust_self_signed_cert.isSelected());
        if (StringUtil.isNotEmpty(this.jtf_ssl_keystore_file.getText())) {
            out.setKeyStore(this.jtf_ssl_keystore_file.getText());
        }
        if (this.jpf_ssl_keystore_pwd.getPassword().length > 0) {
            out.setKeyStorePassword(this.jpf_ssl_keystore_pwd.getPassword());
        }
        if (StringUtil.isNotEmpty(this.jtf_ssl_truststore_file.getText())) {
            out.setTrustStore(this.jtf_ssl_truststore_file.getText());
        }
        if (this.jpf_ssl_truststore_pwd.getPassword().length > 0) {
            out.setTrustStorePassword(this.jpf_ssl_truststore_pwd.getPassword());
        }
        return out;
    }

    @Override
    public void setSslReq(SSLReq sslReq) {
        this.jcb_ssl_hostname_verifier.setSelectedItem((Object)sslReq.getHostNameVerifier());
        this.jcb_ssl_trust_self_signed_cert.setSelected(sslReq.isTrustSelfSignedCert());
        this.jtf_ssl_keystore_file.setText(sslReq.getKeyStore());
        if (sslReq.getKeyStorePassword() != null) {
            this.jpf_ssl_keystore_pwd.setText(new String(sslReq.getKeyStorePassword()));
        }
        this.jtf_ssl_truststore_file.setText(sslReq.getTrustStore());
        if (sslReq.getTrustStorePassword() != null) {
            this.jpf_ssl_truststore_pwd.setText(new String(sslReq.getTrustStorePassword()));
        }
    }

    @Override
    public void clear() {
        this.jcb_ssl_hostname_verifier.setSelectedItem((Object)SSLHostnameVerifier.STRICT);
        this.jcb_ssl_trust_self_signed_cert.setSelected(false);
        this.jtf_ssl_keystore_file.setText("");
        this.jtf_ssl_truststore_file.setText("");
        this.jpf_ssl_keystore_pwd.setText("");
        this.jpf_ssl_truststore_pwd.setText("");
    }

    @PostConstruct
    protected void init() {
        this.setLayout(new BorderLayout(5, 2));
        JTabbedPane jtp_ssl = new JTabbedPane();
        JPanel jpGrid = new JPanel(new GridLayout(2, 1));
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout(0));
        this.jcb_ssl_trust_self_signed_cert.setHorizontalTextPosition(2);
        jp.add(this.jcb_ssl_trust_self_signed_cert);
        jpGrid.add(jp);
        jp = new JPanel();
        jp.setLayout(new FlowLayout(0));
        jp.add(new JLabel(" Hostname verifier:"));
        jp.add(this.jcb_ssl_hostname_verifier);
        jpGrid.add(jp);
        jtp_ssl.addTab("General", UIUtil.getFlowLayoutPanelLeftAligned(jpGrid));
        JPanel jp2 = new JPanel(new BorderLayout(5, 2));
        JPanel jp_label = new JPanel(new GridLayout(2, 1));
        jp_label.add(UIUtil.getFlowLayoutPanelLeftAligned(new JLabel("Truststore file:")));
        jp_label.add(UIUtil.getFlowLayoutPanelLeftAligned(new JLabel("Truststore password:")));
        jp2.add((Component)jp_label, "West");
        JPanel jp_input = new JPanel(new GridLayout(2, 1));
        JPanel jp_truststore_file = UIUtil.getFlowLayoutPanelLeftAligned(this.jtf_ssl_truststore_file);
        this.jb_ssl_browse.setToolTipText("Open truststore file.");
        this.jb_ssl_browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File f = ReqSSLPanelImpl.this.rest_ui.getOpenFile(FileChooserType.OPEN_GENERIC);
                if (f != null) {
                    if (f.canRead()) {
                        ReqSSLPanelImpl.this.jtf_ssl_truststore_file.setText(f.getAbsolutePath());
                    } else {
                        ReqSSLPanelImpl.this.view.setStatusMessage("Truststore file cannot be read.");
                    }
                }
            }
        });
        jp_truststore_file.add(this.jb_ssl_browse);
        jp_input.add(jp_truststore_file);
        jp_input.add(UIUtil.getFlowLayoutPanelLeftAligned(this.jpf_ssl_truststore_pwd));
        jp2.add((Component)jp_input, "Center");
        jtp_ssl.addTab("Truststore", UIUtil.getFlowLayoutPanelLeftAligned(jp2));
        jp2 = new JPanel(new BorderLayout(5, 2));
        jp_label = new JPanel(new GridLayout(2, 1));
        jp_label.add(UIUtil.getFlowLayoutPanelLeftAligned(new JLabel("Keystore file:")));
        jp_label.add(UIUtil.getFlowLayoutPanelLeftAligned(new JLabel("Keystore password:")));
        jp2.add((Component)jp_label, "West");
        jp_input = new JPanel(new GridLayout(2, 1));
        JPanel jp_keystore_file = UIUtil.getFlowLayoutPanelLeftAligned(this.jtf_ssl_keystore_file);
        this.jb_ssl_keystore_browse.setToolTipText("Open keystore file.");
        this.jb_ssl_keystore_browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File f = ReqSSLPanelImpl.this.rest_ui.getOpenFile(FileChooserType.OPEN_GENERIC);
                if (f != null) {
                    if (f.canRead()) {
                        ReqSSLPanelImpl.this.jtf_ssl_keystore_file.setText(f.getAbsolutePath());
                    } else {
                        ReqSSLPanelImpl.this.view.setStatusMessage("Keystore file cannot be read.");
                    }
                }
            }
        });
        jp_keystore_file.add(this.jb_ssl_keystore_browse);
        jp_input.add(jp_keystore_file);
        jp_input.add(UIUtil.getFlowLayoutPanelLeftAligned(this.jpf_ssl_keystore_pwd));
        jp2.add((Component)jp_input, "Center");
        jtp_ssl.addTab("Keystore", UIUtil.getFlowLayoutPanelLeftAligned(jp2));
        this.add(jtp_ssl);
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

