/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.ContentTypeBean;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetChangeListener;

public class BodyContentTypeDialog
extends EscapableDialog {
    private static final String[] contentTypeArr;
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private static final String[] charSetArr;
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String PARAM_CONTENT_TYPE_STR = "application/x-www-form-urlencoded";
    public static final Charset PARAM_CHARSET;
    public static final ContentType PARAM_CONTENT_TYPE;
    private JComboBox jcb_content_type = new JComboBox<String>(contentTypeArr);
    private JComboBox jcb_charset = new JComboBox<String>(charSetArr);
    private String contentType = "text/plain";
    private String charset = "UTF-8";
    private List<ContentTypeCharsetChangeListener> listeners = new ArrayList<ContentTypeCharsetChangeListener>();

    @Inject
    public BodyContentTypeDialog(RESTUserInterface rest_ui) {
        super((Frame)rest_ui.getFrame(), true);
        this.setTitle("Body Content-type");
        this.jcb_content_type.setSelectedItem(DEFAULT_CONTENT_TYPE);
        this.jcb_charset.setSelectedItem(DEFAULT_CHARSET);
    }

    @PostConstruct
    protected void init() {
        this.jcb_content_type.setEditable(true);
        this.jcb_charset.setEditable(true);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        JPanel jp_center = new JPanel();
        jp_center.setLayout(new BorderLayout());
        JPanel jp_center_west = new JPanel();
        jp_center_west.setLayout(new GridLayout(2, 1, 5, 5));
        JLabel jl_content_type = new JLabel("Content-type: ");
        jl_content_type.setLabelFor(this.jcb_content_type);
        JLabel jl_char_set = new JLabel("Charset: ");
        jl_char_set.setLabelFor(this.jcb_charset);
        jp_center_west.add(jl_content_type);
        jp_center_west.add(jl_char_set);
        jp_center.add((Component)jp_center_west, "West");
        JPanel jp_center_center = new JPanel();
        jp_center_center.setLayout(new GridLayout(2, 1, 5, 5));
        jp_center_center.add(this.jcb_content_type);
        jp_center_center.add(this.jcb_charset);
        jp_center.add((Component)jp_center_center, "Center");
        jp.add((Component)jp_center, "Center");
        JPanel jp_south = new JPanel();
        jp_south.setLayout(new FlowLayout(1));
        JButton jb_ok = new JButton("Ok");
        jb_ok.setMnemonic('o');
        this.getRootPane().setDefaultButton(jb_ok);
        jb_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BodyContentTypeDialog.this.hideMe(true);
            }
        });
        JButton jb_cancel = new JButton("Cancel");
        jb_cancel.setMnemonic('c');
        jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BodyContentTypeDialog.this.hideMe(false);
            }
        });
        jp_south.add(jb_ok);
        jp_south.add(jb_cancel);
        jp.add((Component)jp_south, "South");
        JPanel jp_encp = new JPanel();
        jp_encp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jp_encp.add(jp);
        AutoCompleteDecorator.decorate(this.jcb_charset);
        AutoCompleteDecorator.decorate(this.jcb_content_type);
        this.setContentPane(jp_encp);
        this.pack();
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.hideMe(false);
    }

    void hideMe(boolean isOk) {
        if (isOk) {
            this.contentType = (String)this.jcb_content_type.getSelectedItem();
            this.charset = (String)this.jcb_charset.getSelectedItem();
            for (ContentTypeCharsetChangeListener listener : this.listeners) {
                listener.changed(this.contentType, this.charset);
            }
        } else {
            this.jcb_content_type.setSelectedItem(this.contentType);
            this.jcb_charset.setSelectedItem(this.charset);
        }
        this.setVisible(false);
    }

    String getContentType() {
        return this.contentType;
    }

    void setContentType(String contentType) {
        this.contentType = contentType;
        this.jcb_content_type.setSelectedItem(contentType);
        for (ContentTypeCharsetChangeListener listener : this.listeners) {
            listener.changed(contentType, this.charset);
        }
    }

    String getCharsetString() {
        return this.charset;
    }

    Charset getCharset() {
        if (StringUtil.isEmpty(this.charset)) {
            return null;
        }
        return Charset.forName(this.charset);
    }

    void setCharset(Charset c) {
        this.setCharset(c.name());
    }

    void setCharset(String charset) {
        this.charset = charset;
        this.jcb_charset.setSelectedItem(charset);
        for (ContentTypeCharsetChangeListener listener : this.listeners) {
            listener.changed(this.contentType, charset);
        }
    }

    public void addContentTypeCharSetChangeListener(ContentTypeCharsetChangeListener listener) {
        this.listeners.add(listener);
    }

    static {
        PARAM_CHARSET = Charsets.UTF_8;
        PARAM_CONTENT_TYPE = new ContentTypeBean(PARAM_CONTENT_TYPE_STR, PARAM_CHARSET);
        InputStream is = BodyContentTypeDialog.class.getClassLoader().getResourceAsStream("org/wiztools/restclient/mime.types");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        String[] arr = null;
        try {
            ArrayList<String> ll = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                ll.add(line);
            }
            arr = new String[ll.size()];
            arr = ll.toArray(arr);
        }
        catch (IOException ex) {
            arr = new String[]{DEFAULT_CONTENT_TYPE, "application/xml", "application/json", PARAM_CONTENT_TYPE_STR};
        }
        try {
            br.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        contentTypeArr = arr;
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        int size = charsets.size();
        charSetArr = new String[size];
        int i = 0;
        Iterator i$ = charsets.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            BodyContentTypeDialog.charSetArr[i] = key = (String)i$.next();
            ++i;
        }
    }
}

