/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.ContentTypeBean;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqbody.BodyContentTypeDialog;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetChangeListener;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetComponent;
import org.wiztools.restclient.util.HttpUtil;

public class ContentTypeCharsetComponentImpl
extends JPanel
implements ContentTypeCharsetComponent {
    @Inject
    private BodyContentTypeDialog jd;
    private static final String DEFAULT_CONTENT_CHARSET = HttpUtil.getFormattedContentType("text/plain", "UTF-8");
    private JTextField jtf_content_type_charset = new JTextField(DEFAULT_CONTENT_CHARSET, 26);
    private JButton jb_body_content_type = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/edit.png"));

    @PostConstruct
    protected void init() {
        this.setLayout(new FlowLayout(0));
        this.jtf_content_type_charset.setEditable(false);
        this.add(this.jtf_content_type_charset);
        this.jd.addContentTypeCharSetChangeListener(new ContentTypeCharsetChangeListener(){

            @Override
            public void changed(String contentType, String charset) {
                String formatted = HttpUtil.getFormattedContentType(contentType, charset);
                ContentTypeCharsetComponentImpl.this.jtf_content_type_charset.setText(formatted);
            }
        });
        this.jb_body_content_type.setToolTipText("Edit Content-type & Charset");
        this.jb_body_content_type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContentTypeCharsetComponentImpl.this.jd.setVisible(true);
            }
        });
        this.add(this.jb_body_content_type);
    }

    @Override
    public void requestFocus() {
        this.jb_body_content_type.requestFocus();
    }

    @Override
    public void setContentTypeCharset(ContentType contentType) {
        if (contentType != null) {
            this.setContentTypeCharset(contentType.getContentType(), contentType.getCharset());
        }
    }

    @Override
    public ContentType getContentType() {
        if (StringUtil.isNotEmpty(this.jd.getContentType())) {
            return new ContentTypeBean(this.jd.getContentType(), this.jd.getCharset());
        }
        return null;
    }

    @Override
    public void setContentTypeCharset(String contentType, Charset charset) {
        this.jd.setContentType(contentType);
        if (charset != null) {
            this.jd.setCharset(charset);
        }
        this.jtf_content_type_charset.setText(HttpUtil.getFormattedContentType(contentType, charset));
    }

    public void setContentType(ContentType contentType) {
        this.setContentTypeCharset(contentType.getContentType(), contentType.getCharset());
    }

    @Override
    public void setContentType(String contentType) {
        this.jd.setContentType(contentType);
        String charset = this.jd.getCharsetString();
        this.jtf_content_type_charset.setText(HttpUtil.getFormattedContentType(contentType, charset));
    }

    @Override
    public String getContentTypeCharsetString() {
        return this.jtf_content_type_charset.getText();
    }

    @Override
    public String getContentTypeString() {
        return HttpUtil.getMimeFromContentType(this.jtf_content_type_charset.getText());
    }

    @Override
    public void setCharset(Charset charset) {
        this.jd.setCharset(charset);
        this.jtf_content_type_charset.setText(HttpUtil.getFormattedContentType(this.jd.getContentType(), charset));
    }

    @Override
    public Charset getCharset() {
        return this.jd.getCharset();
    }

    @Override
    public String getCharsetString() {
        return this.jd.getCharsetString();
    }

    @Override
    public void enableComponent() {
        this.jtf_content_type_charset.setEnabled(true);
        this.jb_body_content_type.setEnabled(true);
    }

    @Override
    public void disableComponent() {
        this.jtf_content_type_charset.setEnabled(false);
        this.jb_body_content_type.setEnabled(false);
    }

    @Override
    public void clear() {
        this.jtf_content_type_charset.setText(DEFAULT_CONTENT_CHARSET);
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

