/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.JOptionPane;
import org.wiztools.commons.FileUtil;
import org.wiztools.restclient.XMLException;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetComponent;
import org.wiztools.restclient.util.XMLUtil;

final class ContentTypeSelectorOnFile {
    private ContentTypeSelectorOnFile() {
    }

    static void select(ContentTypeCharsetComponent jp_content_type_charset, File file, Component parent) {
        int result;
        String origContentType;
        String mime = FileUtil.getMimeType(file);
        if (!mime.equals("content/unknown") && !mime.equals(origContentType = jp_content_type_charset.getContentType().getContentType()) && (result = JOptionPane.showConfirmDialog(parent, "The content-type selected (" + origContentType + ") does NOT match\n" + "the computed file mime type (" + mime + ")\n" + "Do you want to update the content-type to `" + mime + "'?", "Mime-type mismatch correction", 0)) == 0) {
            jp_content_type_charset.setContentType(mime);
            if ("application/xml".equals(mime)) {
                try {
                    int charsetYesNo;
                    String charset = XMLUtil.getDocumentCharset(file);
                    if (charset != null && !charset.equals(jp_content_type_charset.getCharsetString()) && (charsetYesNo = JOptionPane.showConfirmDialog(parent, "Change charset to `" + charset + "'?", "Change charset?", 0)) == 0) {
                        jp_content_type_charset.setCharset(Charset.forName(charset));
                    }
                }
                catch (IOException ex) {
                }
                catch (XMLException ex) {
                    // empty catch block
                }
            }
        }
    }
}

