/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityFile;
import org.wiztools.restclient.bean.ReqEntityFileBean;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetComponent;
import org.wiztools.restclient.ui.reqbody.ContentTypeSelectorOnFile;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanel;

public class ReqBodyPanelFile
extends JPanel
implements ReqBodyPanel {
    @Inject
    private RESTUserInterface rest_ui;
    @Inject
    private ContentTypeCharsetComponent jp_content_type_charset;
    private JButton jb_body_file = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private JTextField jtf_file = new JTextField(26);

    @PostConstruct
    public void init() {
        this.setLayout(new BorderLayout());
        JPanel jp_north = new JPanel(new FlowLayout(0));
        jp_north.add(this.jp_content_type_charset.getComponent());
        this.add((Component)jp_north, "North");
        this.jb_body_file.setToolTipText("Select file");
        this.jb_body_file.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReqBodyPanelFile.this.selectFile();
            }
        });
        JPanel jp_center = new JPanel(new FlowLayout(0));
        jp_center.add(this.jtf_file);
        jp_center.add(this.jb_body_file);
        this.add((Component)UIUtil.getFlowLayoutPanelLeftAligned(jp_center), "Center");
    }

    private void selectFile() {
        File f = this.rest_ui.getOpenFile(FileChooserType.OPEN_REQUEST_BODY);
        if (f == null) {
            return;
        }
        if (!f.canRead()) {
            JOptionPane.showMessageDialog(this.rest_ui.getFrame(), "File not readable: " + f.getAbsolutePath(), "IO Error", 0);
            return;
        }
        ContentTypeSelectorOnFile.select(this.jp_content_type_charset, f, this.rest_ui.getFrame());
        this.jtf_file.setText(f.getAbsolutePath());
    }

    @Override
    public void enableBody() {
        this.jp_content_type_charset.enableComponent();
        this.jtf_file.setEnabled(true);
        this.jb_body_file.setEnabled(true);
    }

    @Override
    public void disableBody() {
        this.jp_content_type_charset.disableComponent();
        this.jtf_file.setEnabled(false);
        this.jb_body_file.setEnabled(false);
    }

    @Override
    public void clear() {
        this.jp_content_type_charset.clear();
        this.jtf_file.setText("");
    }

    @Override
    public void setEntity(ReqEntity entity) {
        if (entity instanceof ReqEntityFile) {
            ReqEntityFile e = (ReqEntityFile)entity;
            this.jp_content_type_charset.setContentTypeCharset(e.getContentType());
            File body = e.getBody();
            this.jtf_file.setText(body.getAbsolutePath());
        }
    }

    @Override
    public ReqEntity getEntity() {
        File file = new File(this.jtf_file.getText());
        ReqEntityFileBean entity = new ReqEntityFileBean(file, this.jp_content_type_charset.getContentType());
        return entity;
    }

    @Override
    public void requestFocus() {
        this.jp_content_type_charset.requestFocus();
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

