/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityByteArray;
import org.wiztools.restclient.bean.ReqEntityFile;
import org.wiztools.restclient.bean.ReqEntityMultipart;
import org.wiztools.restclient.bean.ReqEntityString;
import org.wiztools.restclient.bean.ReqEntityUrlStream;
import org.wiztools.restclient.ui.FontableEditor;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanel;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanelByteArray;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanelFile;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanelMultipart;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanelNone;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanelString;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanelUrlStream;

public class ReqBodyPanelImpl
extends JPanel
implements ReqBodyPanel,
FontableEditor {
    @Inject
    RESTView view;
    @Inject
    RESTUserInterface rest_ui;
    @Inject
    private ReqBodyPanelNone jp_body_none;
    @Inject
    private ReqBodyPanelString jp_body_string;
    @Inject
    private ReqBodyPanelFile jp_body_file;
    @Inject
    private ReqBodyPanelByteArray jp_body_byte_array;
    @Inject
    private ReqBodyPanelUrlStream jp_body_url_stream;
    @Inject
    private ReqBodyPanelMultipart jp_body_multipart;
    private final List<ReqBodyPanel> allPanels = new ArrayList<ReqBodyPanel>();
    private static final String NONE_BODY = "None";
    private static final String STRING_BODY = "String body";
    private static final String FILE_BODY = "File body";
    private static final String BYTE_ARRAY_BODY = "Byte-array body";
    private static final String URL_STREAM_BODY = "URL Stream body";
    private static final String MULTIPART_BODY = "Multipart body";
    private static final String[] comboValues = new String[]{"None", "String body", "File body", "Byte-array body", "URL Stream body", "Multipart body"};
    private JComboBox jcb_body_type = new JComboBox<String>(comboValues);

    private JPanel getPanelFromSelection() {
        if (this.jcb_body_type.getSelectedItem().equals(NONE_BODY)) {
            return this.jp_body_none;
        }
        if (this.jcb_body_type.getSelectedItem().equals(STRING_BODY)) {
            return this.jp_body_string;
        }
        if (this.jcb_body_type.getSelectedItem().equals(FILE_BODY)) {
            return this.jp_body_file;
        }
        if (this.jcb_body_type.getSelectedItem().equals(BYTE_ARRAY_BODY)) {
            return this.jp_body_byte_array;
        }
        if (this.jcb_body_type.getSelectedItem().equals(URL_STREAM_BODY)) {
            return this.jp_body_url_stream;
        }
        if (this.jcb_body_type.getSelectedItem().equals(MULTIPART_BODY)) {
            return this.jp_body_multipart;
        }
        throw new RuntimeException("Will NEVER reach here!");
    }

    @Override
    public void setEntity(ReqEntity entity) {
        if (entity instanceof ReqEntityString) {
            this.jcb_body_type.setSelectedItem(STRING_BODY);
            this.jp_body_string.setEntity(entity);
        } else if (entity instanceof ReqEntityFile) {
            this.jcb_body_type.setSelectedItem(FILE_BODY);
            this.jp_body_file.setEntity(entity);
        } else if (entity instanceof ReqEntityByteArray) {
            this.jcb_body_type.setSelectedItem(BYTE_ARRAY_BODY);
            this.jp_body_byte_array.setEntity(entity);
        } else if (entity instanceof ReqEntityUrlStream) {
            this.jcb_body_type.setSelectedItem(URL_STREAM_BODY);
            this.jp_body_url_stream.setEntity(entity);
        } else if (entity instanceof ReqEntityMultipart) {
            this.jcb_body_type.setSelectedItem(MULTIPART_BODY);
            this.jp_body_multipart.setEntity(entity);
        } else {
            this.jcb_body_type.setSelectedItem(NONE_BODY);
        }
    }

    @Override
    public ReqEntity getEntity() {
        ReqBodyPanel panel = (ReqBodyPanel)((Object)this.getPanelFromSelection());
        return panel.getEntity();
    }

    @Override
    public void enableBody() {
        this.jcb_body_type.setEnabled(true);
        for (ReqBodyPanel panel : this.allPanels) {
            panel.enableBody();
        }
    }

    @Override
    public void disableBody() {
        this.jcb_body_type.setEnabled(false);
        for (ReqBodyPanel panel : this.allPanels) {
            panel.disableBody();
        }
    }

    @Override
    public void clear() {
        this.jcb_body_type.setSelectedItem(NONE_BODY);
        for (ReqBodyPanel panel : this.allPanels) {
            panel.clear();
        }
    }

    @PostConstruct
    protected void init() {
        this.allPanels.add(this.jp_body_string);
        this.allPanels.add(this.jp_body_file);
        this.allPanels.add(this.jp_body_byte_array);
        this.allPanels.add(this.jp_body_url_stream);
        this.allPanels.add(this.jp_body_multipart);
        final JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(this.jp_body_none);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jcb_body_type, "North");
        this.add((Component)jsp, "Center");
        this.jcb_body_type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JPanel jp = ReqBodyPanelImpl.this.getPanelFromSelection();
                jsp.setViewportView(jp);
                jp.requestFocus();
            }
        });
    }

    @Override
    public void setEditorFont(Font font) {
        this.jp_body_string.setEditorFont(font);
    }

    @Override
    public Font getEditorFont() {
        return this.jp_body_string.getEditorFont();
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

