/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.FileUtil;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityString;
import org.wiztools.restclient.bean.ReqEntityStringBean;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.FontableEditor;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.ScriptEditor;
import org.wiztools.restclient.ui.ScriptEditorFactory;
import org.wiztools.restclient.ui.TextEditorSyntax;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqbody.BodyContentTypeDialog;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetComponent;
import org.wiztools.restclient.ui.reqbody.ParameterDialog;
import org.wiztools.restclient.ui.reqbody.ParameterGenerationListener;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanel;

class ReqBodyPanelString
extends JPanel
implements ReqBodyPanel,
FontableEditor {
    @Inject
    RESTView view;
    @Inject
    RESTUserInterface rest_ui;
    @Inject
    private ContentTypeCharsetComponent jp_content_type_charset;
    @Inject
    private ParameterDialog jd_req_paramDialog;
    private final ScriptEditor se_req_body = ScriptEditorFactory.getXMLScriptEditor();
    private JButton jb_body_file = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private JButton jb_body_params = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/insert_parameters.png"));

    ReqBodyPanelString() {
    }

    @PostConstruct
    protected void init() {
        this.jd_req_paramDialog.addParameterGenerationListener(new ParameterGenerationListener(){

            @Override
            public void onParameterGeneration(String params) {
                ReqBodyPanelString.this.se_req_body.setText(params);
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jp_north = new JPanel(new FlowLayout(0));
        jp_north.add(this.jp_content_type_charset.getComponent());
        this.jb_body_file.setToolTipText("Load from file");
        this.jb_body_file.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReqBodyPanelString.this.loadFile();
            }
        });
        jp_north.add(this.jb_body_file);
        this.jb_body_params.setToolTipText("Insert parameters");
        this.jb_body_params.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ReqBodyPanelString.this.canSetReqBodyText()) {
                    ReqBodyPanelString.this.checkAndSetParameterContentType();
                    ReqBodyPanelString.this.jd_req_paramDialog.setLocationRelativeTo(ReqBodyPanelString.this.rest_ui.getFrame());
                    ReqBodyPanelString.this.jd_req_paramDialog.setVisible(true);
                }
            }
        });
        jp_north.add(this.jb_body_params);
        this.add((Component)jp_north, "North");
        final JPopupMenu jpm_req_body = new JPopupMenu();
        JMenu jm_syntax = new JMenu("Syntax Color");
        JMenuItem jmi_syntax_none = new JMenuItem("None");
        jmi_syntax_none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReqBodyPanelString.this.se_req_body.setSyntax(TextEditorSyntax.NONE);
            }
        });
        jm_syntax.add(jmi_syntax_none);
        JMenuItem jmi_syntax_xml = new JMenuItem("XML");
        jmi_syntax_xml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReqBodyPanelString.this.se_req_body.setSyntax(TextEditorSyntax.XML);
            }
        });
        jm_syntax.add(jmi_syntax_xml);
        JMenuItem jmi_syntax_json = new JMenuItem("JSON");
        jmi_syntax_json.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReqBodyPanelString.this.se_req_body.setSyntax(TextEditorSyntax.JSON);
            }
        });
        jm_syntax.add(jmi_syntax_json);
        jpm_req_body.add(jm_syntax);
        this.se_req_body.setPopupMenu(jpm_req_body);
        this.se_req_body.getEditorComponent().addMouseListener(new MouseAdapter(){

            private void eEnable() {
                if (ReqBodyPanelString.this.se_req_body.getEditorComponent().isEnabled()) {
                    Component[] components;
                    for (Component c : components = jpm_req_body.getComponents()) {
                        if (c.isEnabled()) continue;
                        c.setEnabled(true);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.eEnable();
            }
        });
        this.add((Component)this.se_req_body.getEditorView(), "Center");
    }

    private void loadFile() {
        File f = this.rest_ui.getOpenFile(FileChooserType.OPEN_REQUEST_BODY);
        if (f == null) {
            return;
        }
        if (!f.canRead()) {
            JOptionPane.showMessageDialog(this.rest_ui.getFrame(), "File not readable: " + f.getAbsolutePath(), "IO Error", 0);
            return;
        }
        try {
            String body = FileUtil.getContentAsString(f, Charsets.UTF_8);
            this.se_req_body.setText(body);
            this.se_req_body.setCaretPosition(0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.rest_ui.getFrame(), "IO Error: " + ex.getMessage(), "IO Error", 0);
        }
    }

    private boolean canSetReqBodyText() {
        if (StringUtil.isEmpty(this.se_req_body.getText())) {
            return true;
        }
        int response = JOptionPane.showConfirmDialog(this.rest_ui.getFrame(), "Body text exists. Erase?", "Erase?", 0);
        return response == 0;
    }

    private void checkAndSetParameterContentType() {
        int status;
        if (!BodyContentTypeDialog.PARAM_CONTENT_TYPE.equals(this.jp_content_type_charset.getContentType()) && (status = JOptionPane.showConfirmDialog(this.rest_ui.getFrame(), "<html>For parameter the Content-type and Charset needs <br>to be `" + BodyContentTypeDialog.PARAM_CONTENT_TYPE + "' and `" + BodyContentTypeDialog.PARAM_CHARSET + "' respectively.<br>" + "Do you want to set this option?</html>", "Parameter Content-type and Charset", 0)) == 0) {
            this.jp_content_type_charset.setContentTypeCharset(BodyContentTypeDialog.PARAM_CONTENT_TYPE);
        }
    }

    @Override
    public void enableBody() {
        this.jp_content_type_charset.enableComponent();
        this.jb_body_file.setEnabled(true);
        this.jb_body_params.setEnabled(true);
        this.se_req_body.setEnabled(true);
    }

    @Override
    public void disableBody() {
        this.jp_content_type_charset.disableComponent();
        this.jb_body_file.setEnabled(false);
        this.jb_body_params.setEnabled(false);
        this.se_req_body.setEnabled(false);
    }

    @Override
    public void clear() {
        this.jp_content_type_charset.clear();
    }

    @Override
    public void setEntity(ReqEntity entity) {
        if (entity instanceof ReqEntityString) {
            ReqEntityString bean = (ReqEntityString)entity;
            this.jp_content_type_charset.setContentTypeCharset(bean.getContentType());
            this.se_req_body.setText(bean.getBody());
        }
    }

    @Override
    public ReqEntity getEntity() {
        String body = this.se_req_body.getText();
        ReqEntityStringBean entity = new ReqEntityStringBean(body, this.jp_content_type_charset.getContentType());
        return entity;
    }

    @Override
    public void requestFocus() {
        this.se_req_body.getEditorComponent().requestFocus();
    }

    @Override
    public void setEditorFont(Font font) {
        this.se_req_body.getEditorComponent().setFont(font);
    }

    @Override
    public Font getEditorFont() {
        return this.se_req_body.getEditorComponent().getFont();
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

