/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqgo;

import com.jidesoft.swing.AutoCompletion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqgo.ReqUrlGoPanel;
import org.wiztools.restclient.ui.reqgo.UrlListPersistUtil;

public class ReqUrlGoPanelImpl
extends JPanel
implements ReqUrlGoPanel {
    private static final Logger LOG = Logger.getLogger(ReqUrlGoPanelImpl.class.getName());
    @Inject
    private RESTUserInterface rest_ui;
    private ImageIcon icon_go = UIUtil.getIconFromClasspath("org/wiztools/restclient/go.png");
    private ImageIcon icon_stop = UIUtil.getIconFromClasspath("org/wiztools/restclient/stop.png");
    private static final String TEXT_GO = "Go!";
    private static final String TEXT_STOP = "Stop!";
    private final JComboBox jcb_url = new JComboBox();
    private final JButton jb_request = new JButton(this.icon_go);
    private final List<ActionListener> listeners = new ArrayList<ActionListener>();

    @PostConstruct
    protected void init() {
        KeyStroke ks = KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String actionName = "org.wiztools.restclient:ADDRESS_FOCUS";
        this.jcb_url.getInputMap(2).put(ks, "org.wiztools.restclient:ADDRESS_FOCUS");
        this.jcb_url.getActionMap().put("org.wiztools.restclient:ADDRESS_FOCUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReqUrlGoPanelImpl.this.jcb_url.requestFocus();
            }
        });
        JLabel jl_url = new JLabel("URL: ");
        jl_url.setLabelFor(this.jcb_url);
        jl_url.setDisplayedMnemonic('u');
        this.rest_ui.getFrame().getRootPane().setDefaultButton(this.jb_request);
        this.setLayout(new BorderLayout(5, 0));
        this.add((Component)jl_url, "West");
        this.jcb_url.setToolTipText("URL");
        this.jcb_url.setEditable(true);
        this.jcb_url.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JTextField)ReqUrlGoPanelImpl.this.jcb_url.getEditor().getEditorComponent()).selectAll();
            }
        });
        AutoCompletion ac = new AutoCompletion(this.jcb_url);
        ac.setStrict(false);
        ac.setStrictCompletion(false);
        this.add((Component)this.jcb_url, "Center");
        this.jb_request.setToolTipText(TEXT_GO);
        this.rest_ui.getFrame().getRootPane().setDefaultButton(this.jb_request);
        this.jb_request.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ReqUrlGoPanelImpl.this.jb_requestActionPerformed();
            }
        });
        this.add((Component)this.jb_request, "East");
    }

    @PostConstruct
    protected void loadComboHistory() {
        try {
            List<String> urls = UrlListPersistUtil.load();
            if (!urls.isEmpty()) {
                for (String url : urls) {
                    this.jcb_url.addItem(url);
                }
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
    }

    @PostConstruct
    protected void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ArrayList<String> urls = new ArrayList<String>();
                for (int i = 0; i < ReqUrlGoPanelImpl.this.jcb_url.getItemCount(); ++i) {
                    String url = (String)ReqUrlGoPanelImpl.this.jcb_url.getItemAt(i);
                    urls.add(url);
                }
                try {
                    UrlListPersistUtil.persist(urls);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
        });
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public ReqUrlGoPanel.ACTION_TYPE getActionType() {
        if (this.jb_request.getIcon() == this.icon_go) {
            return ReqUrlGoPanel.ACTION_TYPE.GO;
        }
        return ReqUrlGoPanel.ACTION_TYPE.CANCEL;
    }

    private void jb_requestActionPerformed() {
        Object item = this.jcb_url.getSelectedItem();
        int count = this.jcb_url.getItemCount();
        LinkedList l = new LinkedList();
        for (int i = 0; i < count; ++i) {
            l.add(this.jcb_url.getItemAt(i));
        }
        if (l.contains(item)) {
            this.jcb_url.removeItem(item);
            this.jcb_url.insertItemAt(item, 0);
        } else if (((String)item).trim().length() != 0) {
            if (count > 19) {
                this.jcb_url.removeItemAt(count - 1);
            }
            this.jcb_url.insertItemAt(item, 0);
        }
        this.jcb_url.setSelectedItem(item);
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(null);
        }
    }

    @Override
    public String getUrlString() {
        return (String)this.jcb_url.getSelectedItem();
    }

    @Override
    public void setUrlString(String url) {
        this.jcb_url.setSelectedItem(url);
    }

    @Override
    public boolean isSslUrl() {
        try {
            URL url = new URL((String)this.jcb_url.getSelectedItem());
            if (url.getProtocol().equalsIgnoreCase("https")) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.jcb_url.requestFocus();
    }

    @Override
    public void setAsRunning() {
        this.jb_request.setIcon(this.icon_stop);
        this.jb_request.setToolTipText(TEXT_STOP);
    }

    @Override
    public void setAsIdle() {
        this.jb_request.setIcon(this.icon_go);
        this.jb_request.setToolTipText(TEXT_GO);
    }

    @Override
    public boolean isIdle() {
        return this.jb_request.getIcon() == this.icon_go;
    }

    @Override
    public boolean isRunning() {
        return this.jb_request.getIcon() == this.icon_stop;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void clear() {
        this.jcb_url.setSelectedItem(null);
    }
}

