/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqtest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import junit.framework.TestSuite;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.FileUtil;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.TestUtil;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.RequestBean;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.bean.TestException;
import org.wiztools.restclient.bean.TestResult;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.ScriptEditor;
import org.wiztools.restclient.ui.ScriptEditorFactory;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqtest.ReqTestPanel;
import org.wiztools.restclient.ui.reqtest.RunTestDialog;
import org.wiztools.restclient.util.Util;

public class ReqTestPanelImpl
extends JPanel
implements ReqTestPanel {
    @Inject
    private RESTView view;
    @Inject
    private RESTUserInterface rest_ui;
    @Inject
    private RunTestDialog jd_runTestDialog;
    private ScriptEditor se_test_script = ScriptEditorFactory.getGroovyScriptEditor();
    private JButton jb_req_test_template = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/insert_template.png"));
    private JButton jb_req_test_open = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/load_from_file.png"));
    private JButton jb_req_test_run = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/wand.png"));
    private JButton jb_req_test_quick = new JButton(UIUtil.getIconFromClasspath("org/wiztools/restclient/quick_test.png"));
    private static final String templateTestScript;

    @PostConstruct
    protected void init() {
        this.setLayout(new BorderLayout());
        JPanel jp_test_north = new JPanel();
        jp_test_north.setLayout(new FlowLayout(0));
        this.jb_req_test_template.setToolTipText("Insert Template");
        this.jb_req_test_template.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String t = ReqTestPanelImpl.this.se_test_script.getText();
                if (!StringUtil.isEmpty(t)) {
                    JOptionPane.showMessageDialog(ReqTestPanelImpl.this.rest_ui.getFrame(), "Script text already present! Please clear existing script!", "Error", 0);
                    return;
                }
                ReqTestPanelImpl.this.se_test_script.setText(templateTestScript);
                ReqTestPanelImpl.this.se_test_script.setCaretPosition(0);
            }
        });
        jp_test_north.add(this.jb_req_test_template);
        this.jb_req_test_open.setToolTipText("Open Test Script From File");
        this.jb_req_test_open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret;
                String str = ReqTestPanelImpl.this.se_test_script.getText();
                if (!StringUtil.isEmpty(str) && (ret = JOptionPane.showConfirmDialog(ReqTestPanelImpl.this.rest_ui.getFrame(), "Script already exists. Erase?", "Erase existing script?", 0)) == 1) {
                    return;
                }
                File f = ReqTestPanelImpl.this.rest_ui.getOpenFile(FileChooserType.OPEN_TEST_SCRIPT);
                if (f == null) {
                    return;
                }
                if (!f.canRead()) {
                    JOptionPane.showMessageDialog(ReqTestPanelImpl.this.rest_ui.getFrame(), "IO Error (Read permission denied): " + f.getAbsolutePath(), "IO Error", 0);
                    return;
                }
                try {
                    String testScript = FileUtil.getContentAsString(f, Charsets.UTF_8);
                    ReqTestPanelImpl.this.se_test_script.setText(testScript);
                    ReqTestPanelImpl.this.se_test_script.setCaretPosition(0);
                }
                catch (IOException ex) {
                    ReqTestPanelImpl.this.view.showError(Util.getStackTrace(ex));
                }
            }
        });
        jp_test_north.add(this.jb_req_test_open);
        jp_test_north.add(new JSeparator(1));
        this.jb_req_test_run.setToolTipText("Run Test");
        this.jb_req_test_run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty(ReqTestPanelImpl.this.se_test_script.getText())) {
                    JOptionPane.showMessageDialog(ReqTestPanelImpl.this.rest_ui.getFrame(), "No script!", "Error", 0);
                    return;
                }
                if (ReqTestPanelImpl.this.jd_runTestDialog == null) {
                    ReqTestPanelImpl.this.jd_runTestDialog = new RunTestDialog(ReqTestPanelImpl.this.rest_ui);
                }
                ReqTestPanelImpl.this.jd_runTestDialog.setVisible(true);
            }
        });
        jp_test_north.add(this.jb_req_test_run);
        this.jb_req_test_quick.setToolTipText("Quick Run Test-Using last request & response");
        this.jb_req_test_quick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReqTestPanelImpl.this.view.getLastRequest() == null || ReqTestPanelImpl.this.view.getLastResponse() == null) {
                    JOptionPane.showMessageDialog(ReqTestPanelImpl.this.rest_ui.getFrame(), "No Last Request/Response", "Error", 0);
                    return;
                }
                String testScript = ReqTestPanelImpl.this.se_test_script.getText();
                if (StringUtil.isEmpty(testScript)) {
                    JOptionPane.showMessageDialog(ReqTestPanelImpl.this.rest_ui.getFrame(), "No Script", "Error", 0);
                    return;
                }
                ReqTestPanelImpl.this.runClonedRequestTest(ReqTestPanelImpl.this.view.getLastRequest(), ReqTestPanelImpl.this.view.getLastResponse());
            }
        });
        jp_test_north.add(this.jb_req_test_quick);
        this.add((Component)jp_test_north, "North");
        JScrollPane jsp = new JScrollPane(this.se_test_script.getEditorView());
        this.add((Component)jsp, "Center");
    }

    @Override
    public void runClonedRequestTest(Request request, Response response) {
        RequestBean t_request = (RequestBean)request.clone();
        t_request.setTestScript(this.se_test_script.getText());
        try {
            TestSuite ts = TestUtil.getTestSuite(t_request, response);
            TestResult testResult = TestUtil.execute(ts);
            this.view.showMessage("Test Result", testResult.toString());
        }
        catch (TestException ex) {
            this.view.showError(Util.getStackTrace(ex));
        }
    }

    @Override
    public void clear() {
        this.se_test_script.setText("");
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTestScript() {
        return this.se_test_script.getText();
    }

    @Override
    public void setTestScript(String script) {
        this.se_test_script.setText(script);
        this.se_test_script.setCaretPosition(0);
    }

    static {
        InputStream is = RESTView.class.getClassLoader().getResourceAsStream("org/wiztools/restclient/test-script.template");
        String t = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String str = null;
            StringBuilder sb = new StringBuilder();
            while ((str = br.readLine()) != null) {
                sb.append(str).append("\n");
            }
            br.close();
            t = sb.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        templateTestScript = t;
    }
}

