/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqtest;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.wiztools.restclient.XMLException;
import org.wiztools.restclient.bean.ReqResBean;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.FileChooserType;
import org.wiztools.restclient.ui.RCFileFilter;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.util.Util;

public class RunTestDialog
extends EscapableDialog {
    @Inject
    private RESTUserInterface ui;
    @Inject
    private RESTView view;
    private JButton jb_next = new JButton("Next");
    private JButton jb_cancel = new JButton("Cancel");
    private JRadioButton jrb_archive = new JRadioButton("From Request-Response Archive");
    private JRadioButton jrb_last = new JRadioButton("From last Request-Response");
    private JTextField jtf_archive = new JTextField();
    private JButton jb_archive_browse = new JButton("Browse");
    private RunTestDialog me;
    private JFileChooser jfc = UIUtil.getNewJFileChooser();
    private File archiveFile;

    @Inject
    public RunTestDialog(RESTUserInterface ui) {
        super((Frame)ui.getFrame(), true);
        this.setTitle("Run Test");
        this.me = this;
    }

    @PostConstruct
    protected void init() {
        this.jfc.addChoosableFileFilter(new RCFileFilter(".rcr"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.jrb_archive);
        group.add(this.jrb_last);
        this.jrb_archive.setSelected(true);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RunTestDialog.this.jrb_archive.isSelected()) {
                    RunTestDialog.this.jb_archive_browse.setEnabled(true);
                } else {
                    RunTestDialog.this.jb_archive_browse.setEnabled(false);
                }
            }
        };
        this.jrb_archive.addActionListener(al);
        this.jrb_last.addActionListener(al);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        JPanel jp_center = new JPanel();
        jp_center.setBorder(BorderFactory.createTitledBorder("Run Test"));
        jp_center.setLayout(new GridLayout(3, 1));
        jp_center.add(this.jrb_archive);
        JPanel jp_center_file = new JPanel();
        jp_center_file.setLayout(new FlowLayout());
        this.jtf_archive.setColumns(24);
        this.jtf_archive.setEditable(false);
        jp_center_file.add(this.jtf_archive);
        this.jb_archive_browse.setMnemonic('b');
        this.jb_archive_browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = RunTestDialog.this.ui.getOpenFile(FileChooserType.OPEN_ARCHIVE, RunTestDialog.this.me);
                if (f == null) {
                    return;
                }
                RunTestDialog.this.archiveFile = f;
                RunTestDialog.this.jtf_archive.setText(RunTestDialog.this.archiveFile.getAbsolutePath());
            }
        });
        jp_center_file.add(this.jb_archive_browse);
        jp_center.add(jp_center_file);
        jp_center.add(this.jrb_last);
        c.add((Component)jp_center, "Center");
        JPanel jp_south = new JPanel();
        jp_south.setLayout(new FlowLayout(2));
        this.jb_next.setMnemonic('n');
        this.getRootPane().setDefaultButton(this.jb_next);
        this.jb_next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunTestDialog.this.jb_nextAction();
            }
        });
        jp_south.add(this.jb_next);
        this.jb_cancel.setMnemonic('c');
        this.jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunTestDialog.this.close();
            }
        });
        jp_south.add(this.jb_cancel);
        c.add((Component)jp_south, "South");
        this.pack();
    }

    private void jb_nextAction() {
        try {
            Request request = null;
            Response response = null;
            if (this.jrb_archive.isSelected()) {
                if (this.archiveFile == null) {
                    JOptionPane.showMessageDialog(this.ui.getFrame(), "Please select a file!", "Error", 0);
                    return;
                }
                ReqResBean req_res = Util.getReqResArchive(this.archiveFile);
                request = req_res.getRequestBean();
                response = req_res.getResponseBean();
            } else {
                request = this.view.getLastRequest();
                response = this.view.getLastResponse();
                if (request == null || response == null) {
                    JOptionPane.showMessageDialog(this.me, "No last Request/Response available!", "Error", 0);
                    return;
                }
            }
            this.me.setVisible(false);
            this.view.runClonedRequestTest(request, response);
        }
        catch (IOException ex) {
            this.view.showError(Util.getStackTrace(ex));
        }
        catch (XMLException ex) {
            this.view.showError(Util.getStackTrace(ex));
        }
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.close();
    }

    private void close() {
        this.me.setVisible(false);
    }
}

