/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.resbody;

import java.awt.Font;
import java.awt.GridLayout;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JScrollPane;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.ui.FontableEditor;
import org.wiztools.restclient.ui.resbody.AbstractResBody;
import org.wiztools.restclient.ui.resbody.ResBodyBinaryPanel;
import org.wiztools.restclient.ui.resbody.ResBodyImagePanel;
import org.wiztools.restclient.ui.resbody.ResBodyNonePanel;
import org.wiztools.restclient.ui.resbody.ResBodyTextPanel;
import org.wiztools.restclient.util.HttpUtil;

public class ResBodyPanelImpl
extends AbstractResBody
implements FontableEditor {
    @Inject
    private ResBodyTextPanel jp_text;
    @Inject
    private ResBodyImagePanel jp_image;
    @Inject
    private ResBodyBinaryPanel jp_binary;
    @Inject
    private ResBodyNonePanel jp_none;
    private JScrollPane jsp = new JScrollPane();

    @PostConstruct
    protected void init() {
        this.jsp.setViewportView(this.jp_none);
        this.setLayout(new GridLayout());
        this.add(this.jsp);
    }

    @Override
    public void setBody(byte[] body, ContentType type) {
        super.setBody(body, type);
        if (type != null && StringUtil.isNotEmpty(type.getContentType())) {
            if (HttpUtil.isTextContentType(type.getContentType())) {
                this.jp_text.setBody(body, type);
                this.jsp.setViewportView(this.jp_text);
            } else if (HttpUtil.isWebImageContentType(type.getContentType())) {
                this.jp_image.setBody(body, type);
                this.jsp.setViewportView(this.jp_image);
            } else {
                this.setBinaryBody();
            }
        } else {
            this.setBinaryBody();
        }
    }

    private void setBinaryBody() {
        this.jp_binary.setBody(this.body, this.type);
        this.jsp.setViewportView(this.jp_binary);
    }

    @Override
    public void setEditorFont(Font font) {
        this.jp_text.setEditorFont(font);
    }

    @Override
    public Font getEditorFont() {
        return this.jp_text.getEditorFont();
    }

    @Override
    public void clearUI() {
        this.jp_text.clear();
        this.jp_image.clear();
        this.jp_binary.clear();
        this.jsp.setViewportView(this.jp_none);
    }
}

