/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.resbody;

import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ServiceLocator;
import org.wiztools.restclient.XMLException;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.ui.FontableEditor;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.ScriptEditor;
import org.wiztools.restclient.ui.ScriptEditorFactory;
import org.wiztools.restclient.ui.TextEditorSyntax;
import org.wiztools.restclient.ui.resbody.AbstractResBody;
import org.wiztools.restclient.util.HttpUtil;
import org.wiztools.restclient.util.JSONUtil;
import org.wiztools.restclient.util.XMLIndentUtil;

public class ResBodyTextPanel
extends AbstractResBody
implements FontableEditor {
    @Inject
    RESTView view;
    private final ExecutorService xmlIndentThreadPool = Executors.newSingleThreadExecutor();
    private Future xmlIndentFuture;
    private final ScriptEditor se_response = ScriptEditorFactory.getXMLScriptEditor();

    private void actionTextEditorSyntaxChange(ScriptEditor editor, TextEditorSyntax syntax) {
        editor.setSyntax(syntax);
    }

    @PostConstruct
    protected void init() {
        this.se_response.setEditable(false);
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenu jm_indent = new JMenu("Indent");
        JMenuItem jmi_indentXml = new JMenuItem("Indent XML");
        jmi_indentXml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                final String resText = ResBodyTextPanel.this.se_response.getText();
                if ("".equals(resText.trim())) {
                    ResBodyTextPanel.this.view.setStatusMessage("No response body!");
                    return;
                }
                if (ResBodyTextPanel.this.xmlIndentFuture != null && !ResBodyTextPanel.this.xmlIndentFuture.isDone()) {
                    ResBodyTextPanel.this.view.setStatusMessage("Last XML indentation task running!");
                    return;
                }
                ResBodyTextPanel.this.view.setStatusMessage("Starting XML indentation job...");
                new Thread(){

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                TimeUnit.SECONDS.sleep(30L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                            if (ResBodyTextPanel.this.xmlIndentFuture == null || ResBodyTextPanel.this.xmlIndentFuture.isDone()) break;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ResBodyTextPanel.this.view.setStatusMessage("Still running XML indentation job...");
                                }
                            });
                        }
                    }
                }.start();
                ResBodyTextPanel.this.xmlIndentFuture = ResBodyTextPanel.this.xmlIndentThreadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        String status;
                        try {
                            String indentedXML = XMLIndentUtil.getIndented(resText);
                            ResBodyTextPanel.this.se_response.setText(indentedXML);
                            ResBodyTextPanel.this.se_response.setCaretPosition(0);
                            status = "Indent XML: Success";
                            ResBodyTextPanel.this.view.setStatusMessage("Indent XML: Success");
                        }
                        catch (XMLException ex) {
                            status = "Indent XML: XML Parser Configuration Error.";
                            ResBodyTextPanel.this.view.setStatusMessage("Indent XML: XML Parser Configuration Error.");
                        }
                        catch (IOException ex) {
                            status = "Indent XML: IOError while processing XML.";
                            ResBodyTextPanel.this.view.setStatusMessage("Indent XML: IOError while processing XML.");
                        }
                        final String statusMsg = status;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ResBodyTextPanel.this.view.setStatusMessage(statusMsg);
                            }
                        });
                    }
                });
            }
        });
        jm_indent.add(jmi_indentXml);
        JMenuItem jmi_indentJson = new JMenuItem("Indent JSON");
        jmi_indentJson.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String resText = ResBodyTextPanel.this.se_response.getText();
                if ("".equals(resText.trim())) {
                    ResBodyTextPanel.this.view.setStatusMessage("No response body!");
                    return;
                }
                try {
                    String indentedJSON = JSONUtil.indentJSON(resText);
                    ResBodyTextPanel.this.se_response.setText(indentedJSON);
                    ResBodyTextPanel.this.se_response.setCaretPosition(0);
                    ResBodyTextPanel.this.view.setStatusMessage("Indent JSON: Success");
                }
                catch (JSONUtil.JSONParseException ex) {
                    ResBodyTextPanel.this.view.setStatusMessage("Indent JSON: Not a valid JSON text.");
                }
            }
        });
        jm_indent.add(jmi_indentJson);
        popupMenu.add(jm_indent);
        JMenu jm_syntax = new JMenu("Syntax Color");
        JMenuItem jmi_syntax_xml = new JMenuItem("XML");
        jmi_syntax_xml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ResBodyTextPanel.this.actionTextEditorSyntaxChange(ResBodyTextPanel.this.se_response, TextEditorSyntax.XML);
            }
        });
        jm_syntax.add(jmi_syntax_xml);
        JMenuItem jmi_syntax_json = new JMenuItem("JSON");
        jmi_syntax_json.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ResBodyTextPanel.this.actionTextEditorSyntaxChange(ResBodyTextPanel.this.se_response, TextEditorSyntax.JSON);
            }
        });
        jm_syntax.add(jmi_syntax_json);
        JMenuItem jmi_syntax_none = new JMenuItem("None");
        jmi_syntax_none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ResBodyTextPanel.this.actionTextEditorSyntaxChange(ResBodyTextPanel.this.se_response, TextEditorSyntax.NONE);
            }
        });
        jm_syntax.add(jmi_syntax_none);
        popupMenu.add(jm_syntax);
        if (this.se_response.getEditorComponent() instanceof RSyntaxTextArea) {
            this.se_response.getEditorComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if ("".equals(ResBodyTextPanel.this.se_response.getText().trim())) {
                        return;
                    }
                    if (e.isPopupTrigger()) {
                        popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new GridLayout());
        this.add(this.se_response.getEditorView());
    }

    @Override
    public void setEditorFont(Font font) {
        this.se_response.getEditorComponent().setFont(font);
    }

    @Override
    public Font getEditorFont() {
        return this.se_response.getEditorComponent().getFont();
    }

    @Override
    public void setBody(byte[] body, ContentType type) {
        IGlobalOptions options;
        super.setBody(body, type);
        if (this.xmlIndentFuture != null && !this.xmlIndentFuture.isDone()) {
            this.xmlIndentFuture.cancel(true);
        }
        boolean isXml = false;
        boolean isJson = false;
        if (type != null) {
            if (HttpUtil.isXmlContentType(type.getContentType())) {
                isXml = true;
            } else if (HttpUtil.isJsonContentType(type.getContentType())) {
                isJson = true;
            }
        }
        if ((options = ServiceLocator.getInstance(IGlobalOptions.class)).isPropertyTrue("response.body.syntax.color")) {
            if (isXml) {
                this.se_response.setSyntax(TextEditorSyntax.XML);
            }
            if (isJson) {
                this.se_response.setSyntax(TextEditorSyntax.JSON);
            }
        } else {
            this.se_response.setSyntax(TextEditorSyntax.NONE);
        }
        String responseBody = new String(this.getBody(), HttpUtil.getCharsetDefault(type));
        if (options.isPropertyTrue("response.body.indent")) {
            if (isXml) {
                try {
                    String indentedResponseBody = XMLIndentUtil.getIndented(responseBody);
                    this.se_response.setText(indentedResponseBody);
                }
                catch (IOException ex) {
                    this.view.setStatusMessage("XML indentation failed.");
                    this.se_response.setText(responseBody);
                }
                catch (XMLException ex) {
                    this.view.setStatusMessage("XML indentation failed.");
                    this.se_response.setText(responseBody);
                }
            } else if (isJson) {
                try {
                    String indentedResponseBody = JSONUtil.indentJSON(responseBody);
                    this.se_response.setText(indentedResponseBody);
                }
                catch (JSONUtil.JSONParseException ex) {
                    this.view.setStatusMessage("JSON indentation failed.");
                    this.se_response.setText(responseBody);
                }
            } else {
                this.view.setStatusMessage("Response body neither XML nor JSON. No indentation.");
                this.se_response.setText(responseBody);
            }
        } else {
            this.se_response.setText(responseBody);
        }
        this.se_response.setCaretPosition(0);
    }

    @Override
    public void clearUI() {
        this.se_response.setText("");
    }
}

