/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.ContentTypeBean;

public final class HttpUtil {
    public static final ContentType DEFAULT_CONTENT_TYPE = new ContentTypeBean("text/plain", Charsets.UTF_8);
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;

    public static ContentType getContentType(String header) {
        if (header.contains("charset")) {
            Pattern p = Pattern.compile("([^;]+);\\s*charset=([^;]+)");
            Matcher m = p.matcher(header);
            if (m.matches()) {
                String contentType = m.group(1);
                Charset charset = Charset.forName(m.group(2));
                return new ContentTypeBean(contentType, charset);
            }
        } else {
            return new ContentTypeBean(header, null);
        }
        return null;
    }

    public static ContentType getContentType(MultiValueMap<String, String> headers) {
        for (String key : headers.keySet()) {
            if (!"content-type".equalsIgnoreCase(key.trim())) continue;
            return HttpUtil.getContentType(headers.get(key).iterator().next());
        }
        return null;
    }

    public static int getStatusCodeFromStatusLine(String statusLine) {
        int retVal = -1;
        String STATUS_PATTERN = "[^\\s]+\\s([0-9]{3})\\s.*";
        Pattern p = Pattern.compile("[^\\s]+\\s([0-9]{3})\\s.*");
        Matcher m = p.matcher(statusLine);
        if (m.matches()) {
            retVal = Integer.parseInt(m.group(1));
        }
        return retVal;
    }

    public static String getFormattedContentType(String contentType, String charset) {
        String charsetFormatted = StringUtil.isEmpty(charset) ? "" : "; charset=" + charset;
        return contentType + charsetFormatted;
    }

    public static String getFormattedContentType(String contentType, Charset charset) {
        return HttpUtil.getFormattedContentType(contentType, charset != null ? charset.name() : null);
    }

    public static String getFormattedContentType(ContentType contentType) {
        return HttpUtil.getFormattedContentType(contentType.getContentType(), contentType.getCharset());
    }

    public static String getCharsetFromContentType(String contentType) {
        Pattern p = Pattern.compile("^.+charset=([^;]+).*$");
        Matcher m = p.matcher(contentType);
        if (m.matches()) {
            return m.group(1).trim();
        }
        return null;
    }

    public static String getMimeFromContentType(String contentType) {
        int occurance = contentType.indexOf(59);
        if (occurance == -1) {
            return contentType;
        }
        return contentType.substring(0, occurance);
    }

    private static String getContentTypeBeforeSemiColon(String contentType) {
        return contentType.indexOf(59) != -1 ? contentType.split(";")[0] : contentType;
    }

    public static boolean isWebImageContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.equals("image/jpeg") || ct.equals("image/png") || ct.equals("image/gif");
    }

    public static boolean isTextContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("text/") || HttpUtil.isXmlContentType(ct) || HttpUtil.isJsonContentType(ct);
    }

    public static boolean isXmlContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("application/xml") || ct.startsWith("text/xml") || ct.endsWith("+xml");
    }

    public static boolean isJsonContentType(String contentType) {
        String ct = HttpUtil.getContentTypeBeforeSemiColon(contentType);
        return ct.startsWith("application/json") || ct.endsWith("+json");
    }

    public static Charset getCharsetDefault(ContentType type) {
        return type != null ? (type.getCharset() != null ? type.getCharset() : DEFAULT_CHARSET) : DEFAULT_CHARSET;
    }
}

