/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.restclient.Base64Exception;
import org.wiztools.restclient.XMLException;
import org.wiztools.restclient.bean.ReqResBean;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.util.XMLUtil;

public final class Util {
    private static final String ENCODE = "UTF-8";
    private static final int BUFF_SIZE = 4096;

    private Util() {
    }

    public static String base64encode(String inStr) {
        return Util.base64encode(inStr.getBytes(Charsets.UTF_8));
    }

    public static String base64encode(byte[] arr) {
        return Base64.encodeBase64String(arr);
    }

    public static byte[] base64decodeByteArray(String base64Str) throws Base64Exception {
        if (!Base64.isBase64(base64Str)) {
            throw new Base64Exception("Provided string is not Base64 encoded");
        }
        byte[] out = Base64.decodeBase64(base64Str);
        return out;
    }

    public static String base64decode(String base64Str) throws Base64Exception {
        if (!Base64.isBase64(base64Str)) {
            throw new Base64Exception("Provided string is not Base64 encoded");
        }
        byte[] out = Util.base64decodeByteArray(base64Str);
        CharsetDecoder decoder = Charsets.UTF_8.newDecoder();
        try {
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            CharBuffer buffer = decoder.decode(ByteBuffer.wrap(Arrays.copyOf(out, out.length)));
            return buffer.toString();
        }
        catch (MalformedInputException ex) {
            throw new Base64Exception("Input is malformed", ex);
        }
        catch (UnmappableCharacterException ex) {
            throw new Base64Exception("Unmappable characters found", ex);
        }
        catch (CharacterCodingException ex) {
            throw new Base64Exception(ex);
        }
    }

    public static String getStackTrace(Throwable aThrowable) {
        String errorMsg = aThrowable.getMessage();
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return errorMsg + "\n" + ((Object)result).toString();
    }

    public static String getHTMLListFromList(List<String> ll) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><ul>");
        for (String str : ll) {
            sb.append("<li>").append(str).append("</li>");
        }
        sb.append("</ul></html>");
        return sb.toString();
    }

    public static String parameterEncode(MultiValueMap<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            try {
                for (String value : params.get(key)) {
                    String encodedKey = URLEncoder.encode(key, ENCODE);
                    String encodedValue = URLEncoder.encode(value, ENCODE);
                    sb.append(encodedKey).append("=").append(encodedValue).append("&");
                }
            }
            catch (UnsupportedEncodingException ex) {
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createReqResArchive(Request request, Response response, File zipFile) throws IOException, XMLException {
        File requestFile = File.createTempFile("req-", ".xml");
        File responseFile = File.createTempFile("res-", ".xml");
        XMLUtil.writeRequestXML(request, requestFile);
        XMLUtil.writeResponseXML(response, responseFile);
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("request.rcq", requestFile);
        files.put("response.rcs", responseFile);
        byte[] buf = new byte[4096];
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        boolean isSuccess = false;
        try {
            for (String entryName : files.keySet()) {
                int len;
                File entryFile = (File)files.get(entryName);
                FileInputStream fis = new FileInputStream(entryFile);
                zos.putNextEntry(new ZipEntry(entryName));
                while ((len = fis.read(buf)) > 0) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                fis.close();
            }
            isSuccess = true;
        }
        finally {
            IOException ioe = null;
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException ex) {
                    isSuccess = false;
                    ioe = ex;
                }
            }
            if (!isSuccess) {
                zipFile.delete();
            }
            requestFile.delete();
            responseFile.delete();
            if (ioe != null) {
                throw ioe;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReqResBean getReqResArchive(File zipFile) throws FileNotFoundException, IOException, XMLException {
        ReqResBean encpBean = new ReqResBean();
        FileInputStream fis = new FileInputStream(zipFile);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        try {
            ZipEntry entry;
            boolean isReqRead = false;
            boolean isResRead = false;
            while ((entry = zis.getNextEntry()) != null) {
                byte[] data = new byte[4096];
                File tmpFile = File.createTempFile(entry.getName(), "");
                try {
                    int count;
                    FileOutputStream fos = new FileOutputStream(tmpFile);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);
                    while ((count = zis.read(data, 0, 4096)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    if (entry.getName().equals("request.rcq")) {
                        Request reqBean = XMLUtil.getRequestFromXMLFile(tmpFile);
                        encpBean.setRequestBean(reqBean);
                        isReqRead = true;
                        continue;
                    }
                    if (!entry.getName().equals("response.rcs")) continue;
                    Response resBean = XMLUtil.getResponseFromXMLFile(tmpFile);
                    encpBean.setResponseBean(resBean);
                    isResRead = true;
                }
                finally {
                    tmpFile.delete();
                }
            }
            if (!isReqRead || !isResRead) {
                throw new IOException("Archive does not have request.rcq/response.rcs!");
            }
        }
        finally {
            zis.close();
        }
        return encpBean;
    }
}

