/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.wiztools.restclient.XMLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLIndentUtil {
    private XMLIndentUtil() {
    }

    public static String getIndented(String inXml) throws IOException {
        try {
            InputSource src = new InputSource(new StringReader(inXml));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
            boolean keepDeclaration = inXml.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", true);
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            return writer.writeToString(document);
        }
        catch (ParserConfigurationException ex) {
            throw new XMLException(null, ex);
        }
        catch (SAXException ex) {
            throw new XMLException(null, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new XMLException(null, ex);
        }
        catch (InstantiationException ex) {
            throw new XMLException(null, ex);
        }
        catch (IllegalAccessException ex) {
            throw new XMLException(null, ex);
        }
    }
}

