/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.restclient.XMLException;
import org.wiztools.restclient.bean.Auth;
import org.wiztools.restclient.bean.HTTPMethod;
import org.wiztools.restclient.bean.HTTPVersion;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.Request;
import org.wiztools.restclient.bean.RequestBean;
import org.wiztools.restclient.bean.Response;
import org.wiztools.restclient.bean.ResponseBean;
import org.wiztools.restclient.bean.TestExceptionResult;
import org.wiztools.restclient.bean.TestResult;
import org.wiztools.restclient.bean.TestResultBean;
import org.wiztools.restclient.util.Util;
import org.wiztools.restclient.util.XmlAuthUtil;
import org.wiztools.restclient.util.XmlBodyUtil;
import org.wiztools.restclient.util.XmlSslUtil;

public final class XMLUtil {
    private static final Logger LOG = Logger.getLogger(XMLUtil.class.getName());
    private static final String[] VERSIONS = new String[]{"3.0", "3.1", "3.2"};
    public static final String XML_MIME = "application/xml";

    private XMLUtil() {
    }

    protected static void checkIfVersionValid(String restVersion) throws XMLException {
        if (restVersion == null) {
            throw new XMLException("Attribute `version' not available for root element");
        }
        int res = Arrays.binarySearch(VERSIONS, restVersion);
        if (res == -1) {
            throw new XMLException("Version not supported");
        }
    }

    private static Element getRootElement() {
        Element eRoot = new Element("rest-client");
        eRoot.addAttribute(new Attribute("version", "3.2"));
        return eRoot;
    }

    protected static Element getRequestElement(Request bean) {
        String testScript;
        Element e;
        ReqEntity entityBean;
        List<HttpCookie> cookies;
        MultiValueMap<String, String> headers;
        Element reqElement = new Element("request");
        Element e2 = new Element("http-version");
        e2.appendChild(bean.getHttpVersion().versionNumber());
        reqElement.appendChild(e2);
        if (bean.isFollowRedirect()) {
            e2 = new Element("http-follow-redirects");
            reqElement.appendChild(e2);
        }
        if (bean.isIgnoreResponseBody()) {
            e2 = new Element("ignore-response-body");
            reqElement.appendChild(e2);
        }
        e2 = new Element("URL");
        e2.appendChild(bean.getUrl().toString());
        reqElement.appendChild(e2);
        e2 = new Element("method");
        e2.appendChild(bean.getMethod().name());
        reqElement.appendChild(e2);
        Auth auth = bean.getAuth();
        if (auth != null) {
            Element eAuth = XmlAuthUtil.getAuthElement(auth);
            reqElement.appendChild(eAuth);
        }
        if (bean.getSslReq() != null) {
            Element eSsl = XmlSslUtil.getSslReq(bean.getSslReq());
            reqElement.appendChild(eSsl);
        }
        if (!(headers = bean.getHeaders()).isEmpty()) {
            Element e3 = new Element("headers");
            for (String key : headers.keySet()) {
                for (String value : headers.get(key)) {
                    Element ee = new Element("header");
                    ee.addAttribute(new Attribute("key", key));
                    ee.addAttribute(new Attribute("value", value));
                    e3.appendChild(ee);
                }
            }
            reqElement.appendChild(e3);
        }
        if (!(cookies = bean.getCookies()).isEmpty()) {
            Element e4 = new Element("cookies");
            for (HttpCookie cookie : cookies) {
                Element ee = new Element("cookie");
                ee.addAttribute(new Attribute("name", cookie.getName()));
                ee.addAttribute(new Attribute("value", cookie.getValue()));
                e4.appendChild(ee);
            }
            reqElement.appendChild(e4);
        }
        if ((entityBean = bean.getBody()) != null) {
            e = XmlBodyUtil.getReqEntity(entityBean);
            reqElement.appendChild(e);
        }
        if ((testScript = bean.getTestScript()) != null) {
            e = new Element("test-script");
            e.appendChild(testScript);
            reqElement.appendChild(e);
        }
        return reqElement;
    }

    protected static Document request2XML(Request bean) throws XMLException {
        Element reqRootElement = XMLUtil.getRootElement();
        reqRootElement.appendChild(XMLUtil.getRequestElement(bean));
        Document xomDocument = new Document(reqRootElement);
        return xomDocument;
    }

    private static Map<String, String> getHeadersFromHeaderNode(Element node) throws XMLException {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (int i = 0; i < node.getChildElements().size(); ++i) {
            Element headerElement = node.getChildElements().get(i);
            if (!"header".equals(headerElement.getQualifiedName())) {
                throw new XMLException("<headers> element should contain only <header> elements");
            }
            m.put(headerElement.getAttributeValue("key"), headerElement.getAttributeValue("value"));
        }
        return m;
    }

    private static List<HttpCookie> getCookiesFromCookiesNode(Element node) throws XMLException {
        ArrayList<HttpCookie> out = new ArrayList<HttpCookie>();
        for (int i = 0; i < node.getChildElements().size(); ++i) {
            Element e = node.getChildElements().get(i);
            if (!"cookie".equals(e.getQualifiedName())) {
                throw new XMLException("<cookies> element should contain only <cookie> elements");
            }
            HttpCookie cookie = new HttpCookie(e.getAttributeValue("name"), e.getAttributeValue("value"));
            out.add(cookie);
        }
        return out;
    }

    protected static Request getRequestBean(Element requestNode) throws MalformedURLException, XMLException {
        RequestBean requestBean = new RequestBean();
        for (int i = 0; i < requestNode.getChildElements().size(); ++i) {
            Element tNode = requestNode.getChildElements().get(i);
            String nodeName = tNode.getQualifiedName();
            if ("http-version".equals(nodeName)) {
                String t = tNode.getValue();
                HTTPVersion httpVersion = "1.1".equals(t) ? HTTPVersion.HTTP_1_1 : HTTPVersion.HTTP_1_0;
                requestBean.setHttpVersion(httpVersion);
                continue;
            }
            if ("http-follow-redirects".equals(nodeName)) {
                requestBean.setFollowRedirect(true);
                continue;
            }
            if ("ignore-response-body".equals(nodeName)) {
                requestBean.setIgnoreResponseBody(true);
                continue;
            }
            if ("URL".equals(nodeName)) {
                URL url = new URL(tNode.getValue());
                requestBean.setUrl(url);
                continue;
            }
            if ("method".equals(nodeName)) {
                requestBean.setMethod(HTTPMethod.get(tNode.getValue()));
                continue;
            }
            if ("auth".equals(nodeName)) {
                requestBean.setAuth(XmlAuthUtil.getAuth(tNode));
                continue;
            }
            if ("ssl".equals(nodeName)) {
                requestBean.setSslReq(XmlSslUtil.getSslReq(tNode));
                continue;
            }
            if ("headers".equals(nodeName)) {
                Map<String, String> m = XMLUtil.getHeadersFromHeaderNode(tNode);
                for (String key : m.keySet()) {
                    requestBean.addHeader(key, m.get(key));
                }
                continue;
            }
            if ("cookies".equals(nodeName)) {
                List<HttpCookie> cookies = XMLUtil.getCookiesFromCookiesNode(tNode);
                for (HttpCookie cookie : cookies) {
                    requestBean.addCookie(cookie);
                }
                continue;
            }
            if ("body".equals(nodeName)) {
                ReqEntity body = XmlBodyUtil.getReqEntity(tNode);
                requestBean.setBody(body);
                continue;
            }
            if ("test-script".equals(nodeName)) {
                requestBean.setTestScript(tNode.getValue());
                continue;
            }
            throw new XMLException("Invalid element encountered: <" + nodeName + ">");
        }
        return requestBean;
    }

    protected static Request xml2Request(Document doc) throws MalformedURLException, XMLException {
        Element rootNode = doc.getRootElement();
        if (!"rest-client".equals(rootNode.getQualifiedName())) {
            throw new XMLException("Root node is not <rest-client>");
        }
        String rcVersion = rootNode.getAttributeValue("version");
        XMLUtil.checkIfVersionValid(rcVersion);
        if (rootNode.getChildElements().size() != 1) {
            throw new XMLException("There can be only one child node for root node: <request>");
        }
        if (rootNode.getFirstChildElement("request") == null) {
            throw new XMLException("The child node of <rest-client> should be <request>");
        }
        Element requestNode = rootNode.getFirstChildElement("request");
        return XMLUtil.getRequestBean(requestNode);
    }

    protected static Element getResponseElement(Response bean) {
        TestResult testResult;
        byte[] responseBody;
        Element respElement = new Element("response");
        Element respChildSubElement = null;
        Element respChildSubSubElement = null;
        respChildSubElement = new Element("execution-time");
        respChildSubElement.appendChild(String.valueOf(bean.getExecutionTime()));
        respElement.appendChild(respChildSubElement);
        respChildSubElement = new Element("status");
        Attribute codeAttributes = new Attribute("code", String.valueOf(bean.getStatusCode()));
        respChildSubElement.addAttribute(codeAttributes);
        respChildSubElement.appendChild(bean.getStatusLine());
        respElement.appendChild(respChildSubElement);
        MultiValueMap<String, String> headers = bean.getHeaders();
        if (!headers.isEmpty()) {
            Attribute keyAttribute = null;
            Attribute valueAttribute = null;
            respChildSubElement = new Element("headers");
            for (String key : headers.keySet()) {
                for (String value : headers.get(key)) {
                    respChildSubSubElement = new Element("header");
                    keyAttribute = new Attribute("key", key);
                    valueAttribute = new Attribute("value", value);
                    respChildSubSubElement.addAttribute(keyAttribute);
                    respChildSubSubElement.addAttribute(valueAttribute);
                    respChildSubElement.appendChild(respChildSubSubElement);
                }
            }
            respElement.appendChild(respChildSubElement);
        }
        if ((responseBody = bean.getResponseBody()) != null) {
            respChildSubElement = new Element("body");
            String base64encodedBody = Util.base64encode(responseBody);
            respChildSubElement.appendChild(base64encodedBody);
            respElement.appendChild(respChildSubElement);
        }
        if ((testResult = bean.getTestResult()) != null) {
            Element e_line;
            Element e_message;
            List<TestExceptionResult> l;
            respChildSubElement = new Element("test-result");
            Element e_runCount = new Element("run-count");
            e_runCount.appendChild(String.valueOf(testResult.getRunCount()));
            Element e_failureCount = new Element("failure-count");
            e_failureCount.appendChild(String.valueOf(testResult.getFailureCount()));
            Element e_errorCount = new Element("error-count");
            e_errorCount.appendChild(String.valueOf(testResult.getErrorCount()));
            respChildSubElement.appendChild(e_runCount);
            respChildSubElement.appendChild(e_failureCount);
            respChildSubElement.appendChild(e_errorCount);
            if (testResult.getFailureCount() > 0) {
                Element e_failures = new Element("failures");
                l = testResult.getFailures();
                for (TestExceptionResult b : l) {
                    e_message = new Element("message");
                    e_message.appendChild(b.getExceptionMessage());
                    e_line = new Element("line-number");
                    e_line.appendChild(String.valueOf(b.getLineNumber()));
                    Element e_failure = new Element("failure");
                    e_failure.appendChild(e_message);
                    e_failure.appendChild(e_line);
                    e_failures.appendChild(e_failure);
                }
                respChildSubElement.appendChild(e_failures);
            }
            if (testResult.getErrorCount() > 0) {
                Element e_errors = new Element("errors");
                l = testResult.getErrors();
                for (TestExceptionResult b : l) {
                    e_message = new Element("message");
                    e_message.appendChild(b.getExceptionMessage());
                    e_line = new Element("line-number");
                    e_line.appendChild(String.valueOf(b.getLineNumber()));
                    Element e_error = new Element("error");
                    e_error.appendChild(e_message);
                    e_error.appendChild(e_line);
                    e_errors.appendChild(e_error);
                }
                respChildSubElement.appendChild(e_errors);
            }
            Element e_trace = new Element("trace");
            e_trace.appendChild(testResult.toString());
            respChildSubElement.appendChild(e_trace);
            respElement.appendChild(respChildSubElement);
        }
        return respElement;
    }

    protected static Document response2XML(Response bean) throws XMLException {
        Element respRootElement = XMLUtil.getRootElement();
        respRootElement.appendChild(XMLUtil.getResponseElement(bean));
        Document xomDocument = new Document(respRootElement);
        return xomDocument;
    }

    protected static Response xml2Response(Document doc) throws XMLException {
        ResponseBean responseBean = new ResponseBean();
        Element rootNode = doc.getRootElement();
        if (!"rest-client".equals(rootNode.getQualifiedName())) {
            throw new XMLException("Root node is not <rest-client>");
        }
        XMLUtil.checkIfVersionValid(rootNode.getAttributeValue("version"));
        Element tNode = null;
        Element responseNode = null;
        if (rootNode.getChildElements().size() != 1) {
            throw new XMLException("There can be only one child node for root node: <response>");
        }
        if (rootNode.getFirstChildElement("response") == null) {
            throw new XMLException("The child node of <rest-client> should be <response>");
        }
        responseNode = rootNode.getFirstChildElement("response");
        for (int i = 0; i < responseNode.getChildElements().size(); ++i) {
            tNode = responseNode.getChildElements().get(i);
            String nodeName = tNode.getQualifiedName();
            if ("execution-time".equals(nodeName)) {
                responseBean.setExecutionTime(Long.parseLong(tNode.getValue()));
                continue;
            }
            if ("status".equals(nodeName)) {
                responseBean.setStatusLine(tNode.getValue());
                responseBean.setStatusCode(Integer.parseInt(tNode.getAttributeValue("code")));
                continue;
            }
            if ("headers".equals(nodeName)) {
                Map<String, String> m = XMLUtil.getHeadersFromHeaderNode(tNode);
                for (String key : m.keySet()) {
                    responseBean.addHeader(key, m.get(key));
                }
                continue;
            }
            if ("body".equals(nodeName)) {
                String base64body = tNode.getValue();
                responseBean.setResponseBody(Util.base64decodeByteArray(base64body));
                continue;
            }
            if ("test-result".equals(nodeName)) {
                TestResultBean testResultBean = new TestResultBean();
                for (int j = 0; j < tNode.getChildCount(); ++j) {
                    String nn = tNode.getQualifiedName();
                    if ("run-count".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if ("failure-count".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if ("error-count".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if ("failures".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if (!"errors".equals(nn)) continue;
                    throw new XMLException("<headers> element should contain only <header> elements");
                }
                responseBean.setTestResult(testResultBean);
                continue;
            }
            throw new XMLException("Unrecognized element found: <" + nodeName + ">");
        }
        return responseBean;
    }

    protected static void writeXML(Document doc, File f) throws IOException, XMLException {
        try {
            OutputStream out = new FileOutputStream(f);
            out = new BufferedOutputStream(out);
            Serializer serializer = new Serializer(out, XMLUtil.getDocumentCharset(f));
            serializer.write(doc);
            out.close();
        }
        catch (IOException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
    }

    protected static Document getDocumentFromFile(File f) throws IOException, XMLException {
        try {
            Builder parser = new Builder();
            Document doc = parser.build(f);
            return doc;
        }
        catch (ParsingException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
    }

    public static String getDocumentCharset(File f) throws IOException, XMLException {
        XMLEventReader reader = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            reader = inputFactory.createXMLEventReader(new FileInputStream(f));
            XMLEvent event = reader.nextEvent();
            StartDocument document = (StartDocument)event;
            String string = document.getCharacterEncodingScheme();
            return string;
        }
        catch (XMLStreamException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException ex) {
                    LOG.warning(ex.getMessage());
                }
            }
        }
    }

    public static void writeRequestXML(Request bean, File f) throws IOException, XMLException {
        Document doc = XMLUtil.request2XML(bean);
        XMLUtil.writeXML(doc, f);
    }

    public static void writeResponseXML(Response bean, File f) throws IOException, XMLException {
        Document doc = XMLUtil.response2XML(bean);
        XMLUtil.writeXML(doc, f);
    }

    public static Request getRequestFromXMLFile(File f) throws IOException, XMLException {
        Document doc = XMLUtil.getDocumentFromFile(f);
        return XMLUtil.xml2Request(doc);
    }

    public static Response getResponseFromXMLFile(File f) throws IOException, XMLException {
        Document doc = XMLUtil.getDocumentFromFile(f);
        return XMLUtil.xml2Response(doc);
    }

    @Deprecated
    public static String indentXML(String in) throws XMLException, IOException {
        try {
            Builder parser = new Builder();
            Document doc = parser.build(in, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Serializer serializer = new Serializer(baos);
            serializer.setIndent(4);
            serializer.setMaxLength(69);
            serializer.write(doc);
            return new String(baos.toByteArray());
        }
        catch (ParsingException ex) {
            throw new XMLException("XML indentation failed.", ex);
        }
    }

    static {
        Arrays.sort(VERSIONS);
    }
}

