/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import nu.xom.Element;
import nu.xom.Elements;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.XMLException;
import org.wiztools.restclient.bean.Auth;
import org.wiztools.restclient.bean.BasicAuth;
import org.wiztools.restclient.bean.BasicAuthBean;
import org.wiztools.restclient.bean.BasicDigestAuth;
import org.wiztools.restclient.bean.BasicDigestAuthBaseBean;
import org.wiztools.restclient.bean.DigestAuth;
import org.wiztools.restclient.bean.DigestAuthBean;
import org.wiztools.restclient.bean.NtlmAuth;
import org.wiztools.restclient.bean.NtlmAuthBean;
import org.wiztools.restclient.bean.OAuth2BearerAuth;
import org.wiztools.restclient.bean.OAuth2BearerAuthBean;
import org.wiztools.restclient.bean.UsernamePasswordAuth;
import org.wiztools.restclient.util.Util;

class XmlAuthUtil {
    private XmlAuthUtil() {
    }

    static Element getAuthElement(Auth auth) {
        Element eAuth = new Element("auth");
        if (auth instanceof BasicAuth) {
            eAuth.appendChild(XmlAuthUtil.getBasicAuthElement((BasicAuth)auth));
        } else if (auth instanceof DigestAuth) {
            eAuth.appendChild(XmlAuthUtil.getDigestAuthElement((DigestAuth)auth));
        } else if (auth instanceof NtlmAuth) {
            eAuth.appendChild(XmlAuthUtil.getNtlmAuthElement((NtlmAuth)auth));
        } else if (auth instanceof OAuth2BearerAuth) {
            eAuth.appendChild(XmlAuthUtil.getOAuth2BearerElement((OAuth2BearerAuth)auth));
        }
        return eAuth;
    }

    static Element getBasicAuthElement(BasicAuth auth) {
        Element e = new Element("basic");
        XmlAuthUtil.populateBasicDigestElement(e, auth);
        return e;
    }

    static Element getDigestAuthElement(DigestAuth auth) {
        Element e = new Element("digest");
        XmlAuthUtil.populateBasicDigestElement(e, auth);
        return e;
    }

    static Element getNtlmAuthElement(NtlmAuth auth) {
        Element e = new Element("ntlm");
        if (StringUtil.isNotEmpty(auth.getDomain())) {
            Element eDomain = new Element("domain");
            eDomain.appendChild(auth.getDomain());
            e.appendChild(eDomain);
        }
        if (StringUtil.isNotEmpty(auth.getWorkstation())) {
            Element eWorkstation = new Element("workstation");
            eWorkstation.appendChild(auth.getWorkstation());
            e.appendChild(eWorkstation);
        }
        XmlAuthUtil.populateUsernamePasswordElement(e, auth);
        return e;
    }

    static Element getOAuth2BearerElement(OAuth2BearerAuth auth) {
        Element e = new Element("oauth2-bearer");
        if (StringUtil.isNotEmpty(auth.getOAuth2BearerToken())) {
            Element eToken = new Element("token");
            eToken.appendChild(auth.getOAuth2BearerToken());
            e.appendChild(eToken);
        }
        return e;
    }

    static OAuth2BearerAuth getOAuth2BearerAuth(Element eAuth) {
        OAuth2BearerAuthBean out = new OAuth2BearerAuthBean();
        Elements eChildren = eAuth.getChildElements();
        for (int i = 0; i < eChildren.size(); ++i) {
            Element e = eChildren.get(i);
            String name = e.getLocalName();
            if (!name.equals("token")) {
                throw new XMLException("Unknown element in oauth2-bearer auth: " + name);
            }
            out.setOAuth2BearerToken(e.getValue());
        }
        return out;
    }

    static void populateBasicDigestElement(Element eParent, BasicDigestAuth auth) {
        if (StringUtil.isNotEmpty(auth.getHost())) {
            Element eHost = new Element("host");
            eHost.appendChild(auth.getHost());
            eParent.appendChild(eHost);
        }
        if (StringUtil.isNotEmpty(auth.getRealm())) {
            Element eRealm = new Element("realm");
            eRealm.appendChild(auth.getRealm());
            eParent.appendChild(eRealm);
        }
        if (auth.isPreemptive()) {
            Element ePreemptive = new Element("preemptive");
            eParent.appendChild(ePreemptive);
        }
        XmlAuthUtil.populateUsernamePasswordElement(eParent, auth);
    }

    static void populateUsernamePasswordElement(Element eParent, UsernamePasswordAuth auth) {
        if (StringUtil.isNotEmpty(auth.getUsername())) {
            Element eUsername = new Element("username");
            eUsername.appendChild(auth.getUsername());
            eParent.appendChild(eUsername);
        }
        if (auth.getPassword() != null && auth.getPassword().length > 0) {
            Element ePassword = new Element("password");
            ePassword.appendChild(Util.base64encode(new String(auth.getPassword())));
            eParent.appendChild(ePassword);
        }
    }

    static Auth getAuth(Element eAuth) {
        int i = 0;
        Elements eChildren = eAuth.getChildElements();
        if (i < eChildren.size()) {
            Element e = eChildren.get(i);
            String name = e.getLocalName();
            if (name.equals("basic")) {
                return XmlAuthUtil.getBasicAuth(e);
            }
            if (name.equals("digest")) {
                return XmlAuthUtil.getDigestAuth(e);
            }
            if (name.equals("ntlm")) {
                return XmlAuthUtil.getNtlmAuth(e);
            }
            if (name.equals("oauth2-bearer")) {
                return XmlAuthUtil.getOAuth2BearerAuth(e);
            }
            throw new XMLException("Invalid auth element encountered: " + name);
        }
        return null;
    }

    static BasicAuth getBasicAuth(Element eBasicAuth) {
        BasicAuthBean out = new BasicAuthBean();
        XmlAuthUtil.populateBasicDigestAuth(out, eBasicAuth);
        return out;
    }

    static DigestAuth getDigestAuth(Element eDigestAuth) {
        DigestAuthBean out = new DigestAuthBean();
        XmlAuthUtil.populateBasicDigestAuth(out, eDigestAuth);
        return out;
    }

    static void populateBasicDigestAuth(BasicDigestAuthBaseBean bean, Element eAuth) {
        Elements eChildren = eAuth.getChildElements();
        for (int i = 0; i < eChildren.size(); ++i) {
            Element e = eChildren.get(i);
            String name = e.getLocalName();
            if (name.equals("host")) {
                bean.setHost(e.getValue());
                continue;
            }
            if (name.equals("realm")) {
                bean.setRealm(e.getValue());
                continue;
            }
            if (name.equals("username")) {
                bean.setUsername(e.getValue());
                continue;
            }
            if (name.equals("password")) {
                bean.setPassword(XmlAuthUtil.getPassword(e));
                continue;
            }
            if (name.equals("preemptive")) {
                bean.setPreemptive(true);
                continue;
            }
            throw new XMLException("Unknown element in basic/digest auth: " + name);
        }
    }

    static NtlmAuth getNtlmAuth(Element eNtlmAuth) {
        NtlmAuthBean out = new NtlmAuthBean();
        Elements eChildren = eNtlmAuth.getChildElements();
        for (int i = 0; i < eChildren.size(); ++i) {
            Element e = eChildren.get(i);
            String name = e.getLocalName();
            if (name.equals("domain")) {
                out.setDomain(e.getValue());
                continue;
            }
            if (name.equals("workstation")) {
                out.setWorkstation(e.getValue());
                continue;
            }
            if (name.equals("username")) {
                out.setUsername(e.getValue());
                continue;
            }
            if (name.equals("password")) {
                out.setPassword(XmlAuthUtil.getPassword(e));
                continue;
            }
            throw new XMLException("Unknown element in ntlm auth: " + name);
        }
        return out;
    }

    static char[] getPassword(Element ePassword) {
        return Util.base64decode(ePassword.getValue()).toCharArray();
    }
}

