/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.XMLException;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.ContentTypeBean;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityByteArray;
import org.wiztools.restclient.bean.ReqEntityByteArrayBean;
import org.wiztools.restclient.bean.ReqEntityFile;
import org.wiztools.restclient.bean.ReqEntityFileBean;
import org.wiztools.restclient.bean.ReqEntityFilePart;
import org.wiztools.restclient.bean.ReqEntityFilePartBean;
import org.wiztools.restclient.bean.ReqEntityMultipart;
import org.wiztools.restclient.bean.ReqEntityMultipartBean;
import org.wiztools.restclient.bean.ReqEntityPart;
import org.wiztools.restclient.bean.ReqEntityString;
import org.wiztools.restclient.bean.ReqEntityStringBean;
import org.wiztools.restclient.bean.ReqEntityStringPart;
import org.wiztools.restclient.bean.ReqEntityStringPartBean;
import org.wiztools.restclient.bean.ReqEntityUrlStream;
import org.wiztools.restclient.bean.ReqEntityUrlStreamBean;
import org.wiztools.restclient.util.Util;

class XmlBodyUtil {
    private XmlBodyUtil() {
    }

    static ReqEntity getReqEntity(Element eEntity) {
        int i = 0;
        Elements eChildren = eEntity.getChildElements();
        if (i < eChildren.size()) {
            Element e = eChildren.get(i);
            String name = e.getLocalName();
            if ("string".equals(name)) {
                ContentType ct = XmlBodyUtil.getContentType(e);
                String body = e.getValue();
                return new ReqEntityStringBean(body, ct);
            }
            if ("file".equals(name)) {
                ContentType ct = XmlBodyUtil.getContentType(e);
                String filePath = e.getValue();
                return new ReqEntityFileBean(new File(filePath), ct);
            }
            if ("byte-array".equals(name)) {
                ContentType ct = XmlBodyUtil.getContentType(e);
                byte[] body = Util.base64decodeByteArray(e.getValue());
                return new ReqEntityByteArrayBean(body, ct);
            }
            if ("url-stream".equals(name)) {
                try {
                    ContentType ct = XmlBodyUtil.getContentType(e);
                    URL url = new URL(e.getValue());
                    return new ReqEntityUrlStreamBean(ct, url);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if ("multipart".equals(name)) {
                List<ReqEntityPart> parts = XmlBodyUtil.getMultipartParts(e);
                return new ReqEntityMultipartBean(parts);
            }
            throw new XMLException("Unsupported element encountered inside <body>: " + name);
        }
        return null;
    }

    private static List<ReqEntityPart> getMultipartParts(Element e) {
        ArrayList<ReqEntityPart> parts = new ArrayList<ReqEntityPart>();
        Elements children = e.getChildElements();
        for (int i = 0; i < children.size(); ++i) {
            ReqEntityPart part = XmlBodyUtil.getMultipartPart(children.get(i));
            parts.add(part);
        }
        return parts;
    }

    private static ReqEntityPart getMultipartPart(Element e) {
        String name = e.getLocalName();
        String partName = e.getAttributeValue("name");
        ContentType ct = XmlBodyUtil.getContentType(e);
        if ("string".equals(name)) {
            String partBody = e.getValue();
            return new ReqEntityStringPartBean(partName, ct, partBody);
        }
        if ("file".equals(name)) {
            File file = new File(e.getValue());
            return new ReqEntityFilePartBean(partName, ct, file);
        }
        throw new XMLException("Unsupported element encountered inside <multipart>: " + name);
    }

    private static ContentType getContentType(Element e) {
        String contentType = e.getAttributeValue("content-type");
        String charsetStr = e.getAttributeValue("charset");
        if (StringUtil.isNotEmpty(contentType)) {
            return new ContentTypeBean(contentType, charsetStr != null ? Charset.forName(charsetStr) : null);
        }
        return null;
    }

    static Element getReqEntity(ReqEntity bean) {
        Element eBody = new Element("body");
        if (bean instanceof ReqEntityString) {
            ReqEntityString entity = (ReqEntityString)bean;
            Element eStringContent = new Element("string");
            XmlBodyUtil.addContentTypeCharsetAttribute(entity.getContentType(), eStringContent);
            eStringContent.appendChild(entity.getBody());
            eBody.appendChild(eStringContent);
        } else if (bean instanceof ReqEntityFile) {
            ReqEntityFile entity = (ReqEntityFile)bean;
            Element eFile = new Element("file");
            XmlBodyUtil.addContentTypeCharsetAttribute(entity.getContentType(), eFile);
            eFile.appendChild(entity.getBody().getAbsolutePath());
            eBody.appendChild(eFile);
        } else if (bean instanceof ReqEntityByteArray) {
            ReqEntityByteArray entity = (ReqEntityByteArray)bean;
            Element eByte = new Element("byte-array");
            XmlBodyUtil.addContentTypeCharsetAttribute(entity.getContentType(), eByte);
            eByte.appendChild(Util.base64encode(entity.getBody()));
            eBody.appendChild(eByte);
        } else if (bean instanceof ReqEntityUrlStream) {
            ReqEntityUrlStream entity = (ReqEntityUrlStream)bean;
            Element eUrlStream = new Element("url-stream");
            XmlBodyUtil.addContentTypeCharsetAttribute(entity.getContentType(), eUrlStream);
            eUrlStream.appendChild(entity.getUrl().toString());
            eBody.appendChild(eUrlStream);
        } else if (bean instanceof ReqEntityMultipart) {
            ReqEntityMultipart entity = (ReqEntityMultipart)bean;
            Element eMultipart = new Element("multipart");
            List<ReqEntityPart> parts = entity.getBody();
            for (ReqEntityPart part : parts) {
                Element ePart;
                ReqEntityPart p;
                if (part instanceof ReqEntityStringPart) {
                    p = (ReqEntityStringPart)part;
                    ePart = new Element("string");
                    XmlBodyUtil.addContentTypeCharsetAttribute(p.getContentType(), ePart);
                    ePart.addAttribute(new Attribute("name", p.getName()));
                    ePart.appendChild(p.getPart());
                    eMultipart.appendChild(ePart);
                    continue;
                }
                if (!(part instanceof ReqEntityFilePart)) continue;
                p = (ReqEntityFilePart)part;
                ePart = new Element("file");
                XmlBodyUtil.addContentTypeCharsetAttribute(p.getContentType(), ePart);
                ePart.addAttribute(new Attribute("name", p.getName()));
                ePart.appendChild(p.getPart().getAbsolutePath());
                eMultipart.appendChild(ePart);
            }
            eBody.appendChild(eMultipart);
        }
        return eBody;
    }

    private static void addContentTypeCharsetAttribute(ContentType c, Element e) {
        if (c != null) {
            e.addAttribute(new Attribute("content-type", c.getContentType()));
            if (c.getCharset() != null) {
                e.addAttribute(new Attribute("charset", c.getCharset().name()));
            }
        }
    }
}

