/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.util;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.SSLHostnameVerifier;
import org.wiztools.restclient.bean.SSLReq;
import org.wiztools.restclient.bean.SSLReqBean;
import org.wiztools.restclient.util.Util;

class XmlSslUtil {
    private XmlSslUtil() {
    }

    static Element getSslReq(SSLReq req) {
        Element e;
        Element eSsl = new Element("ssl");
        if (req.isTrustSelfSignedCert()) {
            e = new Element("trust-self-signed-cert");
            eSsl.appendChild(e);
        }
        e = new Element("hostname-verifier");
        e.appendChild(req.getHostNameVerifier().name());
        eSsl.appendChild(e);
        if (StringUtil.isNotEmpty(req.getKeyStore())) {
            e = new Element("keystore");
            e.addAttribute(new Attribute("file", req.getKeyStore()));
            e.addAttribute(new Attribute("password", Util.base64encode(new String(req.getKeyStorePassword()))));
            eSsl.appendChild(e);
        }
        if (StringUtil.isNotEmpty(req.getTrustStore())) {
            e = new Element("truststore");
            e.addAttribute(new Attribute("file", req.getTrustStore()));
            e.addAttribute(new Attribute("password", Util.base64encode(new String(req.getTrustStorePassword()))));
            eSsl.appendChild(e);
        }
        return eSsl;
    }

    static SSLReq getSslReq(Element eSsl) {
        SSLReqBean out = new SSLReqBean();
        Elements eChildren = eSsl.getChildElements();
        for (int i = 0; i < eChildren.size(); ++i) {
            Element e = eChildren.get(i);
            String name = e.getLocalName();
            if ("trust-self-signed-cert".equals(name)) {
                out.setTrustSelfSignedCert(true);
                continue;
            }
            if ("hostname-verifier".equals(name)) {
                out.setHostNameVerifier(SSLHostnameVerifier.valueOf(e.getValue()));
                continue;
            }
            if ("keystore".equals(name)) {
                out.setKeyStore(e.getAttributeValue("file"));
                out.setKeyStorePassword(Util.base64decode(e.getAttributeValue("password")).toCharArray());
                continue;
            }
            if (!"truststore".equals(name)) continue;
            out.setTrustStore(e.getAttributeValue("file"));
            out.setTrustStorePassword(Util.base64decode(e.getAttributeValue("password")).toCharArray());
        }
        return out;
    }
}

