/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe;

import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.enuns.DocumentoEnum;
import br.com.swconsultoria.nfe.dom.enuns.ServicosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema_4.consReciNFe.TConsReciNFe;
import br.com.swconsultoria.nfe.schema_4.consReciNFe.TRetConsReciNFe;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import br.com.swconsultoria.nfe.util.StubUtil;
import br.com.swconsultoria.nfe.util.WebServiceUtil;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import br.com.swconsultoria.nfe.wsdl.NFeRetAutorizacao.NFeRetAutorizacao4Stub;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class ConsultaRecibo {
    @Generated
    private static final Logger log = Logger.getLogger(ConsultaRecibo.class.getName());

    private ConsultaRecibo() {
    }

    static TRetConsReciNFe reciboNfe(ConfiguracoesNfe config, String recibo, DocumentoEnum tipoDocumento) throws NfeException {
        try {
            TConsReciNFe consReciNFe = new TConsReciNFe();
            consReciNFe.setVersao("4.00");
            consReciNFe.setTpAmb(config.getAmbiente().getCodigo());
            consReciNFe.setNRec(recibo);
            String xml = XmlNfeUtil.objectToXml(consReciNFe, config.getEncode());
            log.info("[XML-ENVIO]: " + xml);
            OMElement ome = AXIOMUtil.stringToOM((String)xml);
            NFeRetAutorizacao4Stub.NfeDadosMsg dadosMsg = new NFeRetAutorizacao4Stub.NfeDadosMsg();
            dadosMsg.setExtraElement(ome);
            String url = WebServiceUtil.getUrl(config, tipoDocumento, ServicosEnum.CONSULTA_RECIBO);
            NFeRetAutorizacao4Stub stub = new NFeRetAutorizacao4Stub(url);
            StubUtil.configuraHttpClient(stub, config, url);
            if (ObjetoUtil.verifica(config.getTimeout()).isPresent()) {
                stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
                stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
            }
            NFeRetAutorizacao4Stub.NfeResultMsg result = stub.nfeRetAutorizacaoLote(dadosMsg);
            log.info("[XML-RETORNO]: " + result.getExtraElement().toString());
            return XmlNfeUtil.xmlToObject(result.getExtraElement().toString(), TRetConsReciNFe.class);
        }
        catch (CertificadoException | RemoteException | JAXBException | XMLStreamException e) {
            throw new NfeException(e.getMessage(), e);
        }
    }
}

