/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe;

import br.com.swconsultoria.certificado.exception.CertificadoException;
import br.com.swconsultoria.nfe.Assinar;
import br.com.swconsultoria.nfe.Validar;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.nfe.dom.enuns.DocumentoEnum;
import br.com.swconsultoria.nfe.dom.enuns.EstadosEnum;
import br.com.swconsultoria.nfe.dom.enuns.ServicosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TEnviNFe;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TRetEnviNFe;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import br.com.swconsultoria.nfe.util.StubUtil;
import br.com.swconsultoria.nfe.util.WebServiceUtil;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import br.com.swconsultoria.nfe.ws.RetryParameter;
import br.com.swconsultoria.nfe.wsdl.NFeAutorizacao.NFeAutorizacao4Stub;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.xml.sax.InputSource;

class Enviar {
    @Generated
    private static final Logger log = Logger.getLogger(Enviar.class.getName());

    private Enviar() {
    }

    static TEnviNFe montaNfe(ConfiguracoesNfe config, TEnviNFe enviNFe, boolean valida) throws NfeException {
        try {
            String xml = XmlNfeUtil.objectToXml(enviNFe, config.getEncode());
            xml = Assinar.assinaNfe(config, xml, AssinaturaEnum.NFE);
            xml = xml.replaceAll(System.lineSeparator(), "");
            log.info("[XML-ASSINADO]: " + xml);
            if (valida) {
                new Validar().validaXml(config, xml, ServicosEnum.ENVIO);
            }
            return XmlNfeUtil.xmlToObject(xml, TEnviNFe.class);
        }
        catch (Exception e) {
            throw new NfeException(e.getMessage(), e);
        }
    }

    static TRetEnviNFe enviaNfe(ConfiguracoesNfe config, TEnviNFe enviNFe, DocumentoEnum tipoDocumento) throws NfeException {
        try {
            OMElement ome;
            String xml = XmlNfeUtil.objectToXml(enviNFe, config.getEncode());
            if (tipoDocumento.equals((Object)DocumentoEnum.NFE)) {
                ome = AXIOMUtil.stringToOM((String)xml);
            } else {
                OMFactory factory = OMAbstractFactory.getOMFactory();
                ome = factory.getMetaFactory().createOMBuilder(factory, StAXParserConfiguration.NON_COALESCING, new InputSource(new StringReader(xml))).getDocumentElement();
            }
            Iterator children = ome.getChildrenWithLocalName("NFe");
            while (children.hasNext()) {
                OMElement omElementNFe = (OMElement)children.next();
                if (omElementNFe == null || !"NFe".equals(omElementNFe.getLocalName())) continue;
                omElementNFe.addAttribute("xmlns", "http://www.portalfiscal.inf.br/nfe", null);
            }
            log.info("[XML-ENVIO]: " + xml);
            NFeAutorizacao4Stub.NfeDadosMsg dadosMsg = new NFeAutorizacao4Stub.NfeDadosMsg();
            dadosMsg.setExtraElement(ome);
            String url = WebServiceUtil.getUrl(config, tipoDocumento, ServicosEnum.ENVIO);
            NFeAutorizacao4Stub stub = new NFeAutorizacao4Stub(url);
            StubUtil.configuraHttpClient(stub, config, url);
            if (ObjetoUtil.verifica(config.getTimeout()).isPresent()) {
                stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)config.getTimeout());
                stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)config.getTimeout());
            }
            if (tipoDocumento.equals((Object)DocumentoEnum.NFCE) && config.getEstado().equals((Object)EstadosEnum.MG)) {
                stub._getServiceClient().getOptions().setProperty("__CHUNKED__", (Object)false);
            }
            if (ObjetoUtil.verifica(config.getRetry()).isPresent()) {
                RetryParameter.populateRetry(stub, config.getRetry());
            }
            NFeAutorizacao4Stub.NfeResultMsg result = stub.nfeAutorizacaoLote(dadosMsg);
            log.info("[XML-RETORNO]: " + result.getExtraElement().toString());
            return XmlNfeUtil.xmlToObject(result.getExtraElement().toString(), TRetEnviNFe.class);
        }
        catch (CertificadoException | RemoteException | JAXBException | XMLStreamException e) {
            throw new NfeException(e.getMessage(), e);
        }
    }
}

