/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.nfe.Assinar;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.Evento;
import br.com.swconsultoria.nfe.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.nfe.dom.enuns.EventosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema.envEventoCancSubst.TEnvEvento;
import br.com.swconsultoria.nfe.schema.envEventoCancSubst.TEvento;
import br.com.swconsultoria.nfe.schema.envEventoCancSubst.TProcEvento;
import br.com.swconsultoria.nfe.schema.envEventoCancSubst.TRetEvento;
import br.com.swconsultoria.nfe.util.ConfiguracoesUtil;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;

public class CancelamentoSubstituicaoUtil {
    private CancelamentoSubstituicaoUtil() {
    }

    public static TEnvEvento montaCancelamento(Evento cancela, ConfiguracoesNfe configuracao) throws NfeException {
        return CancelamentoSubstituicaoUtil.montaCancelamento(Collections.singletonList(cancela), configuracao);
    }

    public static TEnvEvento montaCancelamento(List<Evento> listaCancela, ConfiguracoesNfe configuracao) throws NfeException {
        if (listaCancela.size() > 20) {
            throw new NfeException("Podem ser enviados no m\u00e1ximo 20 eventos no Lote.");
        }
        TEnvEvento enviEvento = new TEnvEvento();
        enviEvento.setVersao("1.00");
        enviEvento.setIdLote("1");
        listaCancela.forEach(evento -> {
            String id = "ID" + EventosEnum.CANCELAMENTO_SUBSTITUICAO.getCodigo() + evento.getChave() + "01";
            TEvento eventoCancela = new TEvento();
            eventoCancela.setVersao("1.00");
            TEvento.InfEvento infoEvento = new TEvento.InfEvento();
            infoEvento.setId(id);
            infoEvento.setCOrgao(String.valueOf(configuracao.getEstado().getCodigoUF()));
            infoEvento.setTpAmb(configuracao.getAmbiente().getCodigo());
            infoEvento.setCPF(evento.getCpf());
            infoEvento.setCNPJ(evento.getCnpj());
            infoEvento.setChNFe(evento.getChave());
            infoEvento.setDhEvento(XmlNfeUtil.dataNfe(evento.getDataEvento(), configuracao.getZoneId()));
            infoEvento.setTpEvento(EventosEnum.CANCELAMENTO_SUBSTITUICAO.getCodigo());
            infoEvento.setNSeqEvento("1");
            infoEvento.setVerEvento("1.00");
            TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
            detEvento.setVersao("1.00");
            detEvento.setDescEvento("Cancelamento por substituicao");
            detEvento.setCOrgaoAutor(String.valueOf(configuracao.getEstado().getCodigoUF()));
            detEvento.setTpAutor("1");
            detEvento.setVerAplic("1.00");
            detEvento.setNProt(evento.getProtocolo());
            detEvento.setXJust(evento.getMotivo());
            detEvento.setChNFeRef(evento.getChaveSusbstituta());
            infoEvento.setDetEvento(detEvento);
            eventoCancela.setInfEvento(infoEvento);
            enviEvento.getEvento().add(eventoCancela);
        });
        return enviEvento;
    }

    public static String criaProcEventoCancelamento(ConfiguracoesNfe config, TEnvEvento enviEvento, TRetEvento retorno) throws JAXBException, NfeException {
        String xml = XmlNfeUtil.objectToXml(enviEvento, config.getEncode());
        xml = xml.replace(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "").replace("<evento v", "<evento xmlns=\"http://www.portalfiscal.inf.br/nfe\" v");
        String assinado = Assinar.assinaNfe(ConfiguracoesUtil.iniciaConfiguracoes(config), xml, AssinaturaEnum.EVENTO);
        TProcEvento procEvento = new TProcEvento();
        procEvento.setVersao("1.00");
        procEvento.setEvento(XmlNfeUtil.xmlToObject(assinado, TEnvEvento.class).getEvento().get(0));
        procEvento.setRetEvento(retorno);
        return XmlNfeUtil.objectToXml(procEvento, config.getEncode());
    }
}

