/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.nfe.Assinar;
import br.com.swconsultoria.nfe.dom.ConfiguracoesNfe;
import br.com.swconsultoria.nfe.dom.Evento;
import br.com.swconsultoria.nfe.dom.enuns.AssinaturaEnum;
import br.com.swconsultoria.nfe.dom.enuns.EventosEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema.envEpec.TEnvEvento;
import br.com.swconsultoria.nfe.schema.envEpec.TEvento;
import br.com.swconsultoria.nfe.schema.envEpec.TProcEvento;
import br.com.swconsultoria.nfe.schema.envEpec.TRetEnvEvento;
import br.com.swconsultoria.nfe.schema.envEpec.TUf;
import br.com.swconsultoria.nfe.util.ConfiguracoesUtil;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;

public class EpecUtil {
    private EpecUtil() {
    }

    public static TEnvEvento montaEpec(Evento epec, ConfiguracoesNfe configuracao) throws NfeException {
        return EpecUtil.montaEpec(Collections.singletonList(epec), configuracao);
    }

    public static TEnvEvento montaEpec(List<Evento> listaEpec, ConfiguracoesNfe configuracao) throws NfeException {
        if (listaEpec.size() > 20) {
            throw new NfeException("Podem ser enviados no m\u00e1ximo 20 eventos no Lote.");
        }
        TEnvEvento enviEvento = new TEnvEvento();
        enviEvento.setVersao("1.00");
        enviEvento.setIdLote("1");
        listaEpec.forEach(epec -> {
            String id = "ID" + EventosEnum.EPEC.getCodigo() + epec.getChave() + "01";
            TEvento eventoEpec = new TEvento();
            eventoEpec.setVersao("1.00");
            TEvento.InfEvento infoEvento = new TEvento.InfEvento();
            infoEvento.setId(id);
            infoEvento.setCOrgao("91");
            infoEvento.setTpAmb(configuracao.getAmbiente().getCodigo());
            infoEvento.setCPF(epec.getCpf());
            infoEvento.setCNPJ(epec.getCnpj());
            infoEvento.setChNFe(epec.getChave());
            infoEvento.setDhEvento(XmlNfeUtil.dataNfe(epec.getDataEvento(), configuracao.getZoneId()));
            infoEvento.setTpEvento(EventosEnum.EPEC.getCodigo());
            infoEvento.setNSeqEvento("1");
            infoEvento.setVerEvento("1.00");
            TEvento.InfEvento.DetEvento detEvento = new TEvento.InfEvento.DetEvento();
            detEvento.setVersao("1.00");
            detEvento.setDescEvento("EPEC");
            detEvento.setCOrgaoAutor(configuracao.getEstado().getCodigoUF());
            detEvento.setTpAutor("1");
            detEvento.setVerAplic("1.0.0");
            detEvento.setDhEmi(XmlNfeUtil.dataNfe(epec.getDataEvento(), configuracao.getZoneId()));
            detEvento.setTpNF(epec.getEventoEpec().getTipoNF());
            detEvento.setIE(epec.getEventoEpec().getIeEmitente());
            TEvento.InfEvento.DetEvento.Dest dest = new TEvento.InfEvento.DetEvento.Dest();
            dest.setUF(TUf.valueOf(epec.getEventoEpec().getEstadoDestinatario().toString()));
            dest.setCNPJ(epec.getEventoEpec().getCnpjDestinatario());
            dest.setCPF(epec.getEventoEpec().getCpfDestinatario());
            dest.setIE(epec.getEventoEpec().getIeDestinatario());
            dest.setVNF(epec.getEventoEpec().getvNF());
            dest.setVICMS(epec.getEventoEpec().getvICMS());
            dest.setVST(epec.getEventoEpec().getvST());
            detEvento.setDest(dest);
            infoEvento.setDetEvento(detEvento);
            eventoEpec.setInfEvento(infoEvento);
            enviEvento.getEvento().add(eventoEpec);
        });
        return enviEvento;
    }

    public static String criaProcEventoEpec(ConfiguracoesNfe config, TEnvEvento enviEvento, TRetEnvEvento retorno) throws JAXBException, NfeException {
        String xml = XmlNfeUtil.objectToXml(enviEvento, config.getEncode());
        xml = xml.replaceAll(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replace("<evento v", "<evento xmlns=\"http://www.portalfiscal.inf.br/nfe\" v");
        String assinado = Assinar.assinaNfe(ConfiguracoesUtil.iniciaConfiguracoes(config), xml, AssinaturaEnum.EVENTO);
        TProcEvento procEvento = new TProcEvento();
        procEvento.setEvento(XmlNfeUtil.xmlToObject(assinado, TEnvEvento.class).getEvento().get(0));
        procEvento.setRetEvento(retorno.getRetEvento().get(0));
        procEvento.setVersao("1.00");
        return XmlNfeUtil.objectToXml(procEvento, config.getEncode());
    }
}

