/*
 * Decompiled with CFR 0.152.
 */
package br.com.swconsultoria.nfe.util;

import br.com.swconsultoria.nfe.dom.enuns.XsdEnum;
import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TEnviNFe;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TNfeProc;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TProtNFe;
import br.com.swconsultoria.nfe.util.ObjetoUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XmlNfeUtil {
    @Generated
    private static final Logger log = Logger.getLogger(XmlNfeUtil.class.getName());

    private XmlNfeUtil() {
    }

    public static <T> T xmlToObject(String xml, Class<T> classe) {
        return (T)JAXB.unmarshal((Source)new StreamSource(new StringReader(xml)), classe);
    }

    public static String objectToXml(Object objeto) throws JAXBException, NfeException {
        return XmlNfeUtil.objectToXml(objeto, null, null, StandardCharsets.UTF_8);
    }

    public static String objectToXml(Object objeto, Charset encode) throws JAXBException, NfeException {
        return XmlNfeUtil.objectToXml(objeto, null, null, encode);
    }

    public static <T> String objectToXml(T objeto, Class<T> clazz, String nomeElemento) throws JAXBException, NfeException {
        return XmlNfeUtil.objectToXml(objeto, clazz, nomeElemento, StandardCharsets.UTF_8);
    }

    public static <T> String objectToXml(T objeto, Class<T> clazz, String nomeElemento, Charset encode) throws JAXBException, NfeException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{objeto.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"Unicode");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        String encodeXml = encode == null || !Charset.isSupported(encode.displayName()) ? "UTF-8" : encode.displayName();
        sw.append("<?xml version=\"1.0\" encoding=\"").append(encodeXml).append("\"?>");
        StreamResult result = new StreamResult(sw);
        if (clazz == null) {
            XsdEnum xsd = XsdEnum.getByClassName(objeto.getClass().getName());
            clazz = xsd.getClazz();
            nomeElemento = xsd.getName();
        }
        marshaller.marshal((Object)new JAXBElement(new QName("http://www.portalfiscal.inf.br/nfe", nomeElemento), clazz, objeto), (Result)result);
        return XmlNfeUtil.replacesNfe(sw.toString());
    }

    public static String gZipToXml(byte[] conteudo) throws IOException {
        String line;
        if (conteudo == null || conteudo.length == 0) {
            return "";
        }
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(conteudo));
        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8));
        StringBuilder outStr = new StringBuilder();
        while ((line = bf.readLine()) != null) {
            outStr.append(line);
        }
        return outStr.toString();
    }

    public static String criaNfeProc(TEnviNFe enviNfe, Object retorno) throws JAXBException, NfeException {
        TNfeProc nfeProc = new TNfeProc();
        nfeProc.setVersao("4.00");
        nfeProc.setNFe(enviNfe.getNFe().get(0));
        String xml = XmlNfeUtil.objectToXml(retorno);
        nfeProc.setProtNFe(XmlNfeUtil.xmlToObject(xml, TProtNFe.class));
        return XmlNfeUtil.objectToXml(nfeProc);
    }

    private static String replacesNfe(String xml) {
        return xml.replace("<!\\[CDATA\\[<!\\[CDATA\\[", "<!\\[CDATA\\[").replace("\\]\\]>\\]\\]>", "\\]\\]>").replace("ns2:", "").replace("ns3:", "").replace("&lt;", "<").replace("&gt;", ">").replace("<Signature>", "<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">").replace(" xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "").replace(" xmlns=\"\" xmlns:ns3=\"http://www.portalfiscal.inf.br/nfe\"", "").replace("<NFe>", "<NFe xmlns=\"http://www.portalfiscal.inf.br/nfe\">");
    }

    public static String leXml(String arquivo) throws IOException {
        ObjetoUtil.verifica(arquivo).orElseThrow(() -> new IllegalArgumentException("Arquivo xml n\u00e3o pode ser nulo/vazio."));
        if (!Files.exists(Paths.get(arquivo, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException("Arquivo " + arquivo + " n\u00e3o encontrado.");
        }
        List<String> list = Files.readAllLines(Paths.get(arquivo, new String[0]));
        StringJoiner joiner = new StringJoiner("\n");
        list.forEach(joiner::add);
        return joiner.toString();
    }

    public static String dataNfe(LocalDateTime dataASerFormatada) {
        return XmlNfeUtil.dataNfe(dataASerFormatada, ZoneId.systemDefault());
    }

    public static String dataNfe(LocalDateTime dataASerFormatada, ZoneId zoneId) {
        try {
            GregorianCalendar calendar = GregorianCalendar.from(dataASerFormatada.atZone(ObjetoUtil.verifica(zoneId).orElse(ZoneId.of("Brazil/East"))));
            XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
            xmlCalendar.setMillisecond(Integer.MIN_VALUE);
            return xmlCalendar.toString();
        }
        catch (DatatypeConfigurationException e) {
            log.warning(e.getMessage());
            return null;
        }
    }

    public static String getTag(String xml, String tag) throws NfeException {
        if (xml == null || xml.isEmpty()) {
            throw new NfeException("XML de entrada est\u00e1 vazio.");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
            doc.getDocumentElement().normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xPath.evaluate("//*[local-name()='" + tag + "']", doc, XPathConstants.NODE);
            if (node == null) {
                throw new NfeException("Tag '" + tag + "' n\u00e3o encontrada no XML.");
            }
            return XmlNfeUtil.nodeToString(node);
        }
        catch (Exception e) {
            throw new NfeException("Erro ao extrair a tag '" + tag + "' do XML.\nErro: " + e.getMessage(), e);
        }
    }

    private static String nodeToString(Node node) {
        Document document = node.getOwnerDocument();
        DOMImplementationLS domImplLS = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        return serializer.writeToString(node);
    }
}

